/*
Copyright (C) (2020) (Mathieu Bergeron) (mathieu.bergeron@cmontmorency.qc.ca)

This file is part of Ntro, an application framework designed with teaching in mind.

This is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/
package ca.ntro.ntro_core_impl.task_graphs.generic_task_graph;

import java.util.HashMap;
import java.util.Map;

import ca.ntro.core.stream.Stream;
import ca.ntro.ntro_core_impl.graphs.hierarchical_dag.HierarchicalDagNodeBuilder;

public abstract class GenericTaskGroupNtro<T  extends GenericTask<T,ST,ET,TG,G>,
                                           ST extends GenericSimpleTask<T,ST,ET,TG,G>,
                                           ET extends GenericExecutableTask<T,ST,ET,TG,G>,
                                           TG extends GenericTaskGroup<T,ST,ET,TG,G>,
                                           G  extends GenericTaskGraph<T,ST,ET,TG,G>> 

       extends        GenericTaskImpl<T,ST,ET,TG,G>

       implements     GenericTaskGroup<T,ST,ET,TG,G> {
	
	private Map<String, T> tasks = new HashMap<>();

	public Map<String, T> getTasks() {
		return tasks;
	}

	public void setTasks(Map<String, T> tasks) {
		this.tasks = tasks;
	}

	@Override
	public T findTask(String id) {
		return getTasks().get(id);
	}

	@Override
	public ST newTask(String id) {
		return newTask(id, getGraph().getDefaultSimpleTaskOptions());
	}

	// JSWEET @Override leads to compiler error
	//@Override
	public <TT extends ST> TT newTask(String id, SimpleTaskOptions<TT> options) {
		GenericTaskImpl<T,ST,ET,TG,G> newTask = getGraph().newGenericTaskInstance(id, options.getTaskClass());
		
		addGenericSubTask(id, newTask);
		
		((GenericSimpleTaskNtro<T,ST,ET,TG,G>) newTask).setOptions(options);
		
		return (TT) newTask;
	}

	private void addGenericSubTask(String id, GenericTaskImpl<T, ST, ET, TG, G> newTask) {
		nodes().forEach(node -> {
			
			HierarchicalDagNodeBuilder<GenericTaskGraphNode<T, ST, ET, TG, G>, GenericTaskGraphEdge<T, ST, ET, TG, G>> currentNode = (HierarchicalDagNodeBuilder<GenericTaskGraphNode<T, ST, ET, TG, G>, GenericTaskGraphEdge<T, ST, ET, TG, G>> ) node.getNodeStructure();
			HierarchicalDagNodeBuilder<GenericTaskGraphNode<T, ST, ET, TG, G>, GenericTaskGraphEdge<T, ST, ET, TG, G>> newNode = getGraph().getHdagBuilder().addNode(node.id().toKey().toString() + "_" + id);

			currentNode.addSubNode(newNode);
			
			GenericTaskGraphNodeNtro<T,ST,ET,TG,G> newNodeNtro = (GenericTaskGraphNodeNtro<T,ST,ET,TG,G>) newNode.node();

			newNodeNtro.setTask((T) newTask);

			newTask.addNode(newNodeNtro);
		
			getTasks().put(id, (T) newTask);
			
			getGraph().getTasks().put(id, (T) newTask);
		});
	}

	@Override
	public void addTask(ST simpleTask) {
		addGenericSubTask(simpleTask.id(), (GenericTaskImpl<T,ST,ET,TG,G>) simpleTask);
	}

	@Override
	public TG newGroup(String id) {
		return newGroup(id, getGraph().getDefaultTaskGroupOptions());
	}

	// JSWEET @Override leads to compiler error
	//@Override
	public <GG extends TG> GG newGroup(String id, TaskGroupOptions<GG> options) {
		GenericTaskImpl<T,ST,ET,TG,G> newTask = getGraph().newGenericTaskInstance(id, options.taskGroupClass());
		
		addGenericSubTask(id, newTask);

		return (GG) newTask;
	}

	@Override
	public void addGroup(TG taskGroup) {
		addGenericSubTask(taskGroup.id(), (GenericTaskImpl<T,ST,ET,TG,G>) taskGroup);
	}

	@Override
	public boolean isTaskGroup() {
		return true;
	}

	@Override
	public Stream<T> tasks() {
		return Stream.forMapValues(getTasks());
	}

	@Override
	public Stream<T> startTasks() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Stream<T> endTasks() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isEvent() {
		return false;
	}

	@Override
	public boolean isCondition() {
		return false;
	}

	
}
