package depart.frontal.vues;

import ca.ntro.app.Ntro;
import ca.ntro.app.frontend.ViewFx;
import depart.commun.messages.MsgA;
import depart.commun.messages.MsgB;
import depart.frontal.evenements.EvtB;
import depart.maquettes.MaquetteDepart;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;

public class VueA extends ViewFx {

	@FXML
	private Label labelA;

	@FXML
	private TextField textFieldA;

	@FXML
	private Button boutonA;

	@FXML
	private Button boutonB;

	@FXML
	private Button boutonE;

	@Override
	public void initialize() {
		Ntro.assertNotNull(labelA);
		Ntro.assertNotNull(textFieldA);
		Ntro.assertNotNull(boutonA);
		Ntro.assertNotNull(boutonB);
		Ntro.assertNotNull(boutonE);
		
		boutonA.setOnAction(evtFx -> {

			Ntro.newEvent(EvtB.class).trigger();
			
		});
		
		boutonB.setOnAction(evtFx -> {
			
			Ntro.newMessage(MsgA.class)
			    .setParamA(MaquetteDepart.chaineAuHasard())
			    .setParamB(MaquetteDepart.entierAuHasard())
			    .send();
			
		});
		
		boutonE.setOnAction(evtFx -> {
			
			Ntro.newMessage(MsgB.class)
			    .setParamA(textFieldA.getText())
			    .send();

		}); 
	}

	public void methodeA(String texte) {
		labelA.setText(texte);
	}

}
