package depart.dorsal.taches;

import static ca.ntro.app.tasks.backend.BackendTasks.*;

import ca.ntro.app.tasks.backend.BackendTasks;
import depart.commun.messages.MsgA;
import depart.commun.messages.MsgB;
import depart.commun.modeles.ModeleA;

public class TachesG {
	
	public static void creerTaches(BackendTasks tasks) {

		tasks.taskGroup("TachesG")

		     .waitsFor(model(ModeleA.class))
		
		     .contains(subTasks -> {
		    	  
		    	 tacheG1(subTasks);

		    	 tacheG2(subTasks);

		     });
	}


	private static void tacheG1(BackendTasks subTasks) {

		subTasks.task("tacheG1")

		     .waitsFor(model(ModeleA.class))

		     .waitsFor(message(MsgA.class))

		     .executes(inputs -> {

		    	 var objA = inputs.get(message(MsgA.class));
		    	 var objB = inputs.get(model(ModeleA.class));

		    	 objA.methodeA(objB);
		     });
	}

	private static void tacheG2(BackendTasks subTasks) {

		subTasks.task("tacheG2")

		     .waitsFor(model(ModeleA.class))

		     .waitsFor(message(MsgB.class))

		     .executes(inputs -> {

		    	 var objC = inputs.get(message(MsgB.class));
		    	 var objD = inputs.get(model(ModeleA.class));

		    	 objC.methodeA(objD);
		     });
	}

}
