package depart.commun.modeles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ca.ntro.app.Ntro;
import ca.ntro.app.models.Model;
import ca.ntro.app.models.WatchJson;
import ca.ntro.app.models.WriteObjectGraph;
import depart.commun.valeurs.ValeurA;
import depart.frontal.vues.VueA;

public class ModeleA implements Model, WatchJson, WriteObjectGraph {

	private boolean attrA = false;
	private double  attrB = 10.0;

	private Map<String, ValeurA> valeurs = new HashMap<>();
	
	public void methodeC(VueA vueA) {

		vueA.methodeA(this.toString());

	}
	
	public String toString() {

		StringBuilder builder = new StringBuilder();

		builder.append("attrA: " + attrA);
		builder.append(System.lineSeparator());

		builder.append("attrB: " + attrB);
		builder.append(System.lineSeparator());
		builder.append(System.lineSeparator());

		builder.append("valeurs: ");
		builder.append(System.lineSeparator());
		
		for(Map.Entry<String, ValeurA> entry : valeurs.entrySet()) {

			builder.append(entry.getKey());
			builder.append(" -> ");
			builder.append(entry.getValue().toString());
			builder.append(System.lineSeparator());
		}

		return builder.toString();
	}

	public void methodeA(String paramA, int paramB) {
		
		String id = methodeB();

		valeurs.put(id, new ValeurA(id, paramA, paramB));

	}
	
	private String methodeB() {
		String varA = null;

		while(varA == null) {
			
			varA = Ntro.random().nextId(4);

			if(valeurs.containsKey(varA)) {
				varA = null;
			}
		}
		
		return varA;
	}

	public void methodeC(String id) {
		valeurs.remove(id);
	}

}
