package depart.frontal.vues;

import ca.ntro.app.Ntro;
import ca.ntro.app.frontend.ViewFx;
import depart.commun.messages.MsgA;
import depart.commun.messages.MsgB;
import depart.commun.messages.MsgC;
import depart.frontal.evenements.EvtB;
import depart.maquettes.MaquetteDepart;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class VueA extends ViewFx {

	@FXML
	private Label labelA;

	@FXML
	private TextField textFieldA;

	@FXML
	private Button boutonA;

	@FXML
	private Button boutonB;

	@FXML
	private Button boutonC;

	@FXML
	private Button boutonD;

	@FXML
	private Button boutonE;

	@Override
	public void initialize() {
		Ntro.assertNotNull(labelA);
		Ntro.assertNotNull(textFieldA);
		Ntro.assertNotNull(boutonA);
		Ntro.assertNotNull(boutonB);
		Ntro.assertNotNull(boutonC);
		Ntro.assertNotNull(boutonD);
		Ntro.assertNotNull(boutonE);
		
		boutonA.setOnAction(evtFx -> {

			Ntro.newEvent(EvtB.class).trigger();
			
		});
		
		boutonB.setOnAction(evtFx -> {
			
			Ntro.newMessage(MsgA.class)
			    .setParamA(MaquetteDepart.chaineAuHasard())
			    .setParamB(MaquetteDepart.entierAuHasard())
			    .send();
			
		});
		
		boutonC.setOnAction(evtFx -> {
			
			Ntro.newMessage(MsgB.class)
			     .setParamA(-1)
			     .send();

		});

		boutonD.setOnAction(evtFx -> {

			Ntro.newMessage(MsgB.class)
			     .setParamA(+1)
			     .send();

		});
		
		boutonE.setOnAction(evtFx -> {
			
			String varA = textFieldA.getText();
			
			try {
				
				int varB = Integer.parseInt(varA);
				
				Ntro.newMessage(MsgC.class)
				    .setParamA(varB)
				    .send();
				
			}catch(NumberFormatException e) {
				
				textFieldA.setText("");

				Ntro.logger().info("Devait être un entier: " + varA);

			}
		}); 
		
		textFieldA.addEventFilter(KeyEvent.KEY_PRESSED, evtFx -> {

			if(evtFx.getCode().equals(KeyCode.ENTER)) {

				boutonE.fire();

			}

		});
	}

	public void methodeA(String texte) {
		labelA.setText(texte);
	}

	public void methodeB() {
		boutonC.setDisable(false);
	}

	public void methodeC() {
		boutonD.setDisable(false);
	}

	public void methodeD() {
		boutonC.setDisable(true);
	}

	public void methodeE() {
		boutonD.setDisable(true);
	}

	public void methodeF(int paramA) {
		textFieldA.setText(String.valueOf(paramA));
		textFieldA.selectAll();
	}


}
