package depart.frontal;

import ca.ntro.app.Ntro;
import ca.ntro.app.events.EventRegistrar;
import ca.ntro.app.frontend.FrontendFx;
import ca.ntro.app.frontend.ViewRegistrarFx;
import ca.ntro.app.session.SessionRegistrar;
import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.taches.TachesA;
import depart.frontal.taches.TachesB;
import depart.frontal.vues.VueA;
import depart.frontal.taches.TachesC;
import depart.frontal.taches.TachesD;
import depart.frontal.vues.VueB;
import depart.frontal.evenements.EvtA;
import depart.frontal.evenements.EvtB;
import depart.frontal.vues.VueRacine;

public class FrontalDepart implements FrontendFx {

	@Override
	public void registerEvents(EventRegistrar registrar) {

		registrar.registerEvent(EvtA.class);
		registrar.registerEvent(EvtB.class);
	}

	@Override
	public void registerViews(ViewRegistrarFx registrar) {

		registrar.registerDefaultLocale(Ntro.buildLocale("fr"));
		registrar.registerTranslations(Ntro.buildLocale("fr"), "/traductions/fr.properties");
		registrar.registerTranslations(Ntro.buildLocale("en"), "/traductions/en.properties");

		registrar.registerView(VueRacine.class, "/vues/racine.fxml");
		registrar.registerView(VueA.class, "/vues/vue_a.fxml");
		registrar.registerView(VueB.class, "/vues/vue_b.fxml");

		registrar.registerStylesheet("/style/dev.css");
	}

	@Override
	public void registerSessionClass(SessionRegistrar registrar) {
		
	}

	@Override
	public void createTasks(FrontendTasks tasks) {

		TachesA.creerTaches(tasks);
		TachesB.creerTaches(tasks);
		TachesC.creerTaches(tasks);
		TachesD.creerTaches(tasks);
	}

}
