/*
Copyright (C) (2020) (Mathieu Bergeron) (mathieu.bergeron@cmontmorency.qc.ca)

This file is part of Ntro, an application framework designed with teaching in mind.

This is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/
package ca.ntro.ntro_core_impl.wrappers.result;

import ca.ntro.core.NtroCore;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.exceptions.Break;

public class ResultNtro<R extends Object> implements Result<R> {
	
	private R value = null;
	private boolean hasValue = false;
	private Throwable exception = null;

	public ResultNtro() {
	}

	public ResultNtro(R value) {
		registerValue(value);
	}

	public void registerValue(R value) {
		this.value = value;
		this.hasValue = true;
	}

	public void registerException(Throwable exception) {
		this.exception = exception;
	}

	@Override
	public R value() {
		throwException();
		return value;
	}

	@Override
	public boolean hasValue() {
		return this.hasValue;
	}

	@Override
	public boolean hasException() {
		return this.exception != null;
	}

	@Override
	public Throwable exception() {
		return this.exception;
	}

	@Override
	public void throwException() {
		if(exception != null && !(exception instanceof Break)) {
			NtroCoreImpl.logger().fatal(this.exception);
		}
	}
}
