/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.services;

import ca.ntro.ntro_app_fx_impl.frontend.TickNtro;
import ca.ntro.ntro_app_fx_impl.services.TimeFx;
import javafx.animation.AnimationTimer;

public class TimeFxAnimationTimer
extends TimeFx {
    private final double elapsedMinSeconds = 0.004;
    private final double elapsedMaxSeconds = 0.025;
    private AnimationTimer tickTimer = null;

    @Override
    protected void startTickTimer() {
        this.stopTickTimer();
        this.tickTimer = new AnimationTimer(){
            private long lastTick;
            {
                this.lastTick = TimeFxAnimationTimer.this.nowNanoseconds();
            }

            public void handle(long now) {
                long tick = TimeFxAnimationTimer.this.nowNanoseconds();
                double elapsedSeconds = (double)(tick - this.lastTick) / 1.0E9;
                if (elapsedSeconds >= 0.004) {
                    if (elapsedSeconds <= 0.025) {
                        this.lastTick = tick;
                        TimeFxAnimationTimer.this.getTickHandler().addResult((Object)new TickNtro(elapsedSeconds));
                    } else {
                        this.lastTick = tick;
                        TimeFxAnimationTimer.this.getTickHandler().addResult((Object)new TickNtro(0.025));
                    }
                }
            }
        };
        this.tickTimer.start();
    }

    @Override
    protected void stopTickTimer() {
        if (this.tickTimer != null) {
            this.tickTimer.stop();
        }
    }
}

