/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.frontend.window;

import ca.ntro.app.fx.controls.World2dMouseEventFx;
import ca.ntro.app.world2d.Object2dFx;
import ca.ntro.ntro_app_fx_impl.frontend.window.FatalErrorWorld2d;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Glow;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class FatalErrorLetter2d
extends Object2dFx {
    public static final double EPSILON = 1.0;
    private String letter = "";
    private int pos = 0;
    private double fontSize = 20.0;
    private double accelerationY = 1.08;
    private boolean firstAnimationIsDone = false;
    private Glow glowEffect = new Glow(0.0);
    private double secondsToWaitUntilSecondAnimation = 10.0;
    private double secondAnimationElapsedSeconds = 0.0;
    private boolean secondAnimationStarted = false;

    public FatalErrorLetter2d() {
        this.fontSize = 80.0;
        this.setWidth(this.fontSize);
        this.setHeight(this.fontSize);
        this.setTopLeftX(20.0 + this.getWidth() * 0.95 * (double)this.pos);
        this.setTopLeftY(-this.getHeight());
        this.setSpeedX(0.0);
        this.setSpeedY(30.0);
    }

    public String letterId() {
        return this.letter + this.pos;
    }

    @Override
    public void initializeFx() {
    }

    @Override
    public void onAddedToWorld() {
    }

    @Override
    public void onWorldChangesSize(double oldWidth, double oldHeight) {
    }

    public FatalErrorLetter2d(String letter, int pos) {
        this.letter = letter;
        this.pos = pos;
    }

    @Override
    public void drawOnWorld(GraphicsContext gc) {
        if (this.secondAnimationStarted) {
            gc.save();
            this.glowEffect.setLevel(Math.sin((this.secondAnimationElapsedSeconds - this.secondsToWaitUntilSecondAnimation) * 2.0));
            gc.setEffect((Effect)this.glowEffect);
        }
        gc.setFont(FatalErrorWorld2d.FONT_MONO);
        gc.setStroke((Paint)Color.web((String)"#2b2828"));
        gc.setFill((Paint)Color.web((String)"#2b2828"));
        gc.fillText(this.letter, this.getTopLeftX(), this.getTopLeftY());
        gc.strokeText(this.letter, this.getTopLeftX(), this.getTopLeftY());
        if (this.secondAnimationStarted) {
            gc.restore();
        }
    }

    @Override
    public void onTimePasses(double secondsElapsed) {
        super.onTimePasses(secondsElapsed);
        if (!this.firstAnimationIsDone) {
            this.setSpeedY(this.getSpeedY() * this.accelerationY);
            if (this.getTopLeftY() + this.getHeight() >= 200.0) {
                this.setTopLeftY(200.0 - this.getHeight() - 1.0);
                this.setSpeedY(0.0);
                this.firstAnimationIsDone = true;
            }
        } else {
            this.secondAnimationElapsedSeconds += secondsElapsed;
            if (this.secondAnimationElapsedSeconds > this.secondsToWaitUntilSecondAnimation) {
                this.secondAnimationStarted = true;
            }
        }
    }

    @Override
    protected boolean onMouseEvent(World2dMouseEventFx mouseEvent) {
        return false;
    }
}

