/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.frontend;

import ca.ntro.app.Ntro;
import ca.ntro.app.frontend.View;
import ca.ntro.app.frontend.ViewData;
import ca.ntro.app.frontend.ViewLoaderFx;
import ca.ntro.app.frontend.ViewRegistrarFx;
import ca.ntro.app.tasks.frontend.FrontendTasks;
import ca.ntro.core.NtroCore;
import ca.ntro.core.locale.Locale;
import ca.ntro.core.tasks.Task;
import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_app_fx_impl.frontend.ViewRegistrarAccessor;
import ca.ntro.ntro_app_fx_impl.frontend.window.WindowFx;
import ca.ntro.ntro_app_fx_impl.tasks.frontend.FrontendTaskFactory;
import ca.ntro.ntro_core_abstr.tasks.TaskAbstr;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.SimpleTask;
import ca.ntro.ntro_core_impl.tasks.TaskWrapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;

public class ViewRegistrarFxImpl
implements ViewRegistrarFx,
ViewRegistrarAccessor {
    private String userCssPath;
    private String antiCacheCssPath;
    private Map<Locale, String> resourcesPaths = new HashMap<Locale, String>();
    private Locale defaultLocale = Ntro.currentLocale();
    private Map<Class<? extends View<?>>, String> fxmlPaths = new HashMap();
    private Map<Class<? extends View<?>>, View<?>> views = new HashMap();

    @Override
    public <V extends View<?>> void registerFragment(Class<V> viewClass, String fxmlPath) {
        NtroCoreImpl.factory().registerNamedClass(viewClass);
        this.fxmlPaths.put(viewClass, this.fullFxmlPath(fxmlPath));
    }

    private String fullFxmlPath(String fxmlPath) {
        String fullFxmlPath = fxmlPath;
        if (!Ntro.options().useJarResources()) {
            fullFxmlPath = Paths.get(NtroCore.options().resourcesPath(), fxmlPath).toString();
        }
        return fullFxmlPath;
    }

    @Override
    public <V extends View<?>> void registerView(Class<V> viewClass, String fxmlPath) {
        NtroCoreImpl.factory().registerNamedClass(viewClass);
        this.fxmlPaths.put(viewClass, this.fullFxmlPath(fxmlPath));
    }

    @Override
    public void registerDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    @Override
    public void registerTranslations(Locale locale, String resourcesPath) {
        this.resourcesPaths.put(locale, resourcesPath);
    }

    private String userCssPath(String cssPath) {
        String userCssPath = cssPath;
        if (!Ntro.options().useJarResources()) {
            userCssPath = Paths.get(NtroCore.options().resourcesPath(), cssPath).toString();
        }
        return userCssPath;
    }

    @Override
    public void registerStylesheet(String cssPath) {
        this.antiCacheCssPath = this.userCssPath = this.userCssPath(cssPath);
    }

    @Override
    public void registerViewData(Class<? extends ViewData> viewDataClass) {
        NtroCore.factory().registerNamedClass(viewDataClass);
    }

    @Override
    public <V extends View<?>> V view(Class<V> viewClass) {
        return (V)this.views.get(viewClass);
    }

    public void addViewLoaderTasks(FrontendTaskFactory tasks) {
        if (this.fxmlPaths.isEmpty()) {
            return;
        }
        tasks.taskGroup(FrontendTasks.viewLoaders().id()).contains(subTasks -> {
            Map<Class<? extends View<?>>, TaskAbstr> taskByViewClass = this.createTasks((FrontendTasks)subTasks);
            if (!Ntro.options().useJarResources()) {
                this.watchCssFileAndReloadTasks(taskByViewClass);
                this.watchFxmlFilesAndReloadTasks(taskByViewClass);
            }
            this.watchLocaleAndReloadTasks(taskByViewClass);
            this.watchFontSizeAndReloadTasks(taskByViewClass);
        });
    }

    private Map<Class<? extends View<?>>, TaskAbstr> createTasks(FrontendTasks subTasks) {
        HashMap taskByViewClass = new HashMap();
        for (Map.Entry<Class<View<?>>, String> entry : this.fxmlPaths.entrySet()) {
            Class<? extends View<?>> viewClass = entry.getKey();
            String fxmlPath = entry.getValue();
            Task task = subTasks.task(FrontendTasks.viewLoader(viewClass).id()).executesAndReturnsValue(inputs -> this.buildViewLoader(viewClass, fxmlPath, this.userCssPath)).getTask();
            TaskWrapper taskWrapper = (TaskWrapper)task;
            TaskAbstr actualTask = taskWrapper.getTaskImpl();
            taskByViewClass.put(viewClass, actualTask);
        }
        return taskByViewClass;
    }

    private void watchCssFileAndReloadTasks(Map<Class<? extends View<?>>, TaskAbstr> taskByViewClass) {
        if (this.userCssPath == null) {
            return;
        }
        NtroCore.storage().watchFile(this.userCssPath, () -> {
            Path original = Paths.get(this.userCssPath, new String[0]);
            this.antiCacheCssPath = this.nextAntiCacheCssPath(this.userCssPath);
            Path copy = Paths.get(this.antiCacheCssPath, new String[0]);
            try {
                Files.copy(original, copy, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                NtroCore.logger().warning("cannot copy " + this.userCssPath + " to " + this.antiCacheCssPath);
                e.printStackTrace();
            }
            for (Map.Entry entry : taskByViewClass.entrySet()) {
                Class viewClass = (Class)entry.getKey();
                TaskAbstr task = (TaskAbstr)entry.getValue();
                String fxmlPath = this.fxmlPaths.get(viewClass);
                ViewLoaderFx<? extends View<?>> loader = this.buildViewLoader(viewClass, fxmlPath, this.antiCacheCssPath);
                NtroCore.threads().runOnMainThread(() -> {
                    task.cancel();
                    ((SimpleTask)task.asSimpleTask()).addResult((Object)loader);
                });
            }
        });
    }

    private String nextAntiCacheCssPath(String userCssPath) {
        Path path = Paths.get(userCssPath, new String[0]);
        String filename = path.getFileName().toString();
        return Paths.get(NtroCore.options().tmpPath(), filename + "_" + Ntro.random().nextId(8)).toString();
    }

    private void watchFxmlFilesAndReloadTasks(Map<Class<? extends View<?>>, TaskAbstr> taskByViewClass) {
        for (Map.Entry<Class<View<?>>, TaskAbstr> entry : taskByViewClass.entrySet()) {
            Class<? extends View<?>> viewClass = entry.getKey();
            TaskAbstr task = entry.getValue();
            String fxmlPath = this.fxmlPaths.get(viewClass);
            NtroCore.storage().watchFile(fxmlPath, () -> {
                ViewLoaderFx<? extends View<?>> loader = this.buildViewLoader(viewClass, fxmlPath, this.antiCacheCssPath);
                NtroCore.threads().runOnMainThread(() -> {
                    task.cancel();
                    ((SimpleTask)task.asSimpleTask()).addResult((Object)loader);
                });
            });
        }
    }

    private void watchLocaleAndReloadTasks(Map<Class<? extends View<?>>, TaskAbstr> taskByViewClass) {
        NtroCoreImpl.locale().onLocaleChanged(() -> {
            for (Map.Entry entry : taskByViewClass.entrySet()) {
                Class viewClass = (Class)entry.getKey();
                TaskAbstr task = (TaskAbstr)entry.getValue();
                String fxmlPath = this.fxmlPaths.get(viewClass);
                ViewLoaderFx<? extends View<?>> loader = this.buildViewLoader(viewClass, fxmlPath, this.antiCacheCssPath);
                NtroCore.threads().runOnMainThread(() -> {
                    task.cancel();
                    ((SimpleTask)task.asSimpleTask()).addResult((Object)loader);
                });
            }
        });
    }

    private void watchFontSizeAndReloadTasks(Map<Class<? extends View<?>>, TaskAbstr> taskByViewClass) {
        ((WindowFx)NtroImpl.window()).onFontSizeChanged(() -> {
            for (Map.Entry entry : taskByViewClass.entrySet()) {
                Class viewClass = (Class)entry.getKey();
                TaskAbstr task = (TaskAbstr)entry.getValue();
                String fxmlPath = this.fxmlPaths.get(viewClass);
                ViewLoaderFx<? extends View<?>> loader = this.buildViewLoader(viewClass, fxmlPath, this.antiCacheCssPath);
                NtroCore.threads().runOnMainThread(() -> {
                    task.cancel();
                    ((SimpleTask)task.asSimpleTask()).addResult((Object)loader);
                });
            }
        });
    }

    private ViewLoaderFx<? extends View<?>> buildViewLoader(Class<? extends View<?>> viewClass, String fxmlPath, String cssPath) {
        String resourcesPath;
        ViewLoaderFx viewLoader = new ViewLoaderFx();
        viewLoader.setViewClass(viewClass);
        viewLoader.setFxmlPath(fxmlPath);
        if (cssPath != null) {
            viewLoader.setCssPath(cssPath);
        }
        if ((resourcesPath = this.resourcesPaths.get(Ntro.currentLocale())) == null) {
            resourcesPath = this.resourcesPaths.get(this.defaultLocale);
        }
        if (resourcesPath != null) {
            viewLoader.setResourcesPath(resourcesPath);
        }
        return viewLoader;
    }
}

