/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.executable_spec;

import ca.ntro.app.Ntro;
import ca.ntro.app.backend.BackendRegistrar;
import ca.ntro.app.messages.Message;
import ca.ntro.app.messages.MessageRegistrar;
import ca.ntro.app.models.Model;
import ca.ntro.app.models.ModelOrValue;
import ca.ntro.app.models.ModelRegistrar;
import ca.ntro.app.models.ModelValue;
import ca.ntro.core.NtroCore;
import ca.ntro.core.util.Splitter;
import ca.ntro.ntro_app_fx_abstr.NtroExecutable;
import ca.ntro.ntro_app_fx_abstr.messages.MessageAbstr;
import ca.ntro.ntro_app_fx_impl.backend.Backend;
import ca.ntro.ntro_app_fx_impl.backend.DefaultBackend;
import ca.ntro.ntro_app_fx_impl.executable_spec.BackendTasksSpec;
import ca.ntro.ntro_app_fx_impl.tasks.backend.BackendTaskFactory;
import ca.ntro.ntro_core_impl.values.Pair;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public abstract class ExecutableSpec<APP extends NtroExecutable>
implements MessageRegistrar,
ModelRegistrar,
BackendRegistrar {
    private String app = null;
    private transient Class<?> appClass = null;
    private String backend = null;
    private transient Class<? extends Backend> backendClass = DefaultBackend.class;
    private String backendHostname = null;
    private Integer backendPort = null;
    private transient Backend backendObject = new DefaultBackend();
    private transient Consumer<Backend> backendInitializer = null;
    private BackendTasksSpec backendTasks = new BackendTasksSpec();
    private transient BackendTaskFactory backendTaskFactory = new BackendTaskFactory();
    private Map<String, String> messages = new HashMap<String, String>();
    private transient Map<String, Class<?>> messageClasses = new HashMap();
    private Map<String, String> models = new HashMap<String, String>();
    private transient Map<String, Class<?>> modelClasses = new HashMap();
    private Map<String, String> values = new HashMap<String, String>();
    private transient Map<String, Class<?>> valueClasses = new HashMap();

    public void registerAppClass(Class<?> appClass) {
        this.appClass = appClass;
        this.app = appClass.getCanonicalName();
    }

    public void analyzeSources(File resourcesRootDir, File javaRootDir) {
        if (javaRootDir != null && javaRootDir.exists() && javaRootDir.isDirectory()) {
            this.analyzeProjectJavaSources(javaRootDir, javaRootDir);
        }
        if (resourcesRootDir != null && resourcesRootDir.exists() && resourcesRootDir.isDirectory()) {
            this.analyzeProjectResources(resourcesRootDir, resourcesRootDir);
        }
    }

    private void analyzeProjectResources(File resourcesRootDir, File rootDir) {
        for (File file : rootDir.listFiles()) {
            if (file.isDirectory()) {
                this.analyzeProjectResources(resourcesRootDir, file);
                continue;
            }
            Pair baseExtPair = Splitter.analyzeFileName((String)file.getName());
            if (baseExtPair != null) {
                String basename = (String)baseExtPair.left();
                String ext = (String)baseExtPair.right();
                this.analyzeProjectResourceFile(resourcesRootDir, file, basename, ext);
                continue;
            }
            Ntro.logger().warning("a resource file without extension is ignored: (" + file.getAbsolutePath() + ")");
        }
    }

    protected void analyzeProjectResourceFile(File resourcesRootDir, File file, String basename, String ext) {
    }

    private void analyzeProjectJavaSources(File javaRootDir, File currentDir) {
        for (File file : currentDir.listFiles()) {
            if (file.isDirectory()) {
                this.analyzeProjectJavaSources(javaRootDir, file);
                continue;
            }
            Pair baseExtPair = Splitter.analyzeFileName((String)file.getName());
            if (baseExtPair != null) {
                String basename = (String)baseExtPair.left();
                String ext = (String)baseExtPair.right();
                if (!ext.equalsIgnoreCase("java")) continue;
                this.analyzeProjectJavaFile(javaRootDir, file, basename);
                continue;
            }
            Ntro.logger().warning("a source file without extension is ignored: (" + file.getAbsolutePath() + ")");
        }
    }

    protected void analyzeProjectJavaFile(File javaRootDir, File file, String basename) {
        Path relativeFilepath = javaRootDir.toPath().relativize(file.toPath());
        Object fullClassname = "";
        if (relativeFilepath.getNameCount() >= 1) {
            fullClassname = (String)fullClassname + String.valueOf(relativeFilepath.getName(0));
        }
        for (int i = 1; i < relativeFilepath.getNameCount() - 1; ++i) {
            fullClassname = (String)fullClassname + "." + String.valueOf(relativeFilepath.getName(i));
        }
        fullClassname = (String)fullClassname + "." + basename;
        try {
            Class<?> _class = Class.forName((String)fullClassname);
            this.analyzeProjectClass(_class);
        }
        catch (ClassNotFoundException e) {
            Ntro.logger().warning("Cannot load class for file " + file.getAbsolutePath());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected abstract Class<? extends Backend> desiredBackendClass();

    protected void analyzeProjectClass(Class<?> _class) {
        if (NtroCore.reflection().ifClassIsSubTypeOf(_class, Message.class)) {
            this.registerMessage(_class);
        } else if (NtroCore.reflection().ifClassIsSubTypeOf(_class, Model.class)) {
            this.registerModel(_class);
        } else if (NtroCore.reflection().ifClassIsSubTypeOf(_class, ModelValue.class)) {
            this.registerValue(_class);
        } else if (NtroCore.reflection().ifClassIsSubTypeOf(_class, this.desiredBackendClass())) {
            this.registerBackend(_class);
        }
    }

    protected void registerClass(Map<String, String> names, Map<String, Class<?>> classes, Class<?> _class, String classType) {
        String className = _class.getSimpleName();
        String classFullname = _class.getCanonicalName();
        String storedFullname = names.get(className);
        if (storedFullname != null && !storedFullname.equals(classFullname)) {
            Ntro.logger().fatal(String.format("Cannot redeclare %s. %s %s was already declared as %s", classType.toLowerCase(), classType, className, storedFullname));
        } else {
            names.put(className, classFullname);
            classes.put(className, _class);
        }
    }

    @Override
    public <MSG extends MessageAbstr> void registerMessage(Class<MSG> messageClass) {
        this.registerClass(this.messages, this.messageClasses, messageClass, "Message");
    }

    @Override
    public <M extends Model> void registerModel(Class<M> modelClass) {
        this.registerClass(this.models, this.modelClasses, modelClass, "Model");
    }

    @Override
    public <V extends ModelOrValue> void registerValue(Class<V> valueClass) {
        this.registerClass(this.values, this.valueClasses, valueClass, "Value");
    }

    @Override
    public void registerBackend(Class<? extends Backend> backendClass) {
        this.backendClass = backendClass;
        this.backend = backendClass.getCanonicalName();
    }

    public void createBackendAndCallItToFillSpec() {
        this.backendObject = (Backend)NtroCore.factory().newInstance(this.backendClass);
        if (this.backendInitializer != null) {
            this.backendInitializer.accept(this.backendObject);
        }
        if (this.backendObject.isLocalBackend()) {
            this.backendObject.asLocalBackend().createTasks(this.backendTasks);
        }
    }

    public void writeSpec() {
        String jsonString = NtroCore.reflection().toJsonObject((Object)this).toJsonString();
        String basename = this.getClass().getSimpleName();
        String filepath = NtroCore.options().storagePath() + "/" + basename + ".json";
        String relativeFilepath = Paths.get(NtroCore.options().projectPath(), new String[0]).getParent().relativize(Paths.get(filepath, new String[0])).toString();
        NtroCore.logger().info("writing project specification to " + relativeFilepath);
        NtroCore.storage().writeTextFileBlocking(filepath, jsonString);
    }

    public void createExecutableFromSpec() {
        this.registerAllNamedClasses();
        this.backendTasks.createSubTasks(this.backendTaskFactory);
    }

    private void registerAllNamedClasses() {
        this.registerNamedClasses(this.models, this.modelClasses);
        this.registerNamedClasses(this.values, this.valueClasses);
        this.registerNamedClasses(this.messages, this.messageClasses);
    }

    protected void registerNamedClasses(Map<String, String> names, Map<String, Class<?>> classes) {
        for (String name : names.keySet()) {
            Class<?> _class = classes.get(name);
            NtroCore.factory().registerNamedClass(_class);
        }
    }

    public void prepareToExecuteBackendTasks() {
        this.backendTaskFactory.prepareToExecuteTasks();
    }

    public void executeBackendTasks() {
        this.backendTaskFactory.executeTasks();
    }

    public void writeBackendGraph() {
        if (this.backendTaskFactory != null) {
            this.backendTaskFactory.writeGraph();
        }
    }

    protected APP instantiateAppClass() {
        return (APP)((NtroExecutable)NtroCore.factory().newInstance(this.appClass));
    }

    public void callExecutableCodeAndFillSpec() {
        APP app = this.instantiateAppClass();
        this.callExectuableCodeAndFillSpec(app);
    }

    protected void callExectuableCodeAndFillSpec(APP app) {
        app.registerMessages(this);
        app.registerModels(this);
        app.registerBackend(this);
        this.registerAllNamedClasses();
        this.createBackendAndCallItToFillSpec();
        if (this.isRemoteBackend()) {
            this.backendHostname = this.backendObject.asRemoteBackend().getHostname();
            this.backendPort = this.backendObject.asRemoteBackend().getPort();
        }
    }

    public void runExecutable() {
        if (this.isRemoteBackend()) {
            this.backendObject.asRemoteBackend().openConnection();
        } else {
            this.runLocalBackend();
        }
    }

    protected void runLocalBackend() {
        this.prepareToExecuteBackendTasks();
        this.executeBackendTasks();
    }

    public boolean isRemoteBackend() {
        boolean isRemote = false;
        if (this.backendObject != null) {
            isRemote = this.backendObject.isRemoteBackend();
        }
        return isRemote;
    }

    @Override
    public <B extends Backend> void initializeBackendObject(Class<B> backendClass, Consumer<B> backendInitializer) {
        this.backendInitializer = backendInitializer;
    }
}

