/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.backend;

import ca.ntro.app.backend.BackendRegistrar;
import ca.ntro.ntro_app_fx_impl.backend.Backend;
import ca.ntro.ntro_app_fx_impl.backend.DefaultBackend;
import ca.ntro.ntro_app_fx_impl.messages.MessageRegistrarNtro;
import ca.ntro.ntro_app_fx_impl.models.ModelRegistrarImpl;
import ca.ntro.ntro_app_fx_impl.tasks.backend.BackendTaskFactory;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import java.util.function.Consumer;

public class BackendRegistrarNtro
implements BackendRegistrar {
    private BackendTaskFactory taskFactory = new BackendTaskFactory();
    private MessageRegistrarNtro messageRegistrar;
    private ModelRegistrarImpl modelRegistrar;
    private Backend backend = new DefaultBackend();

    public MessageRegistrarNtro getMessageRegistrar() {
        return this.messageRegistrar;
    }

    public void setMessageRegistrar(MessageRegistrarNtro messageRegistrar) {
        this.messageRegistrar = messageRegistrar;
    }

    public ModelRegistrarImpl getModelRegistrar() {
        return this.modelRegistrar;
    }

    public void setModelRegistrar(ModelRegistrarImpl modelRegistrar) {
        this.modelRegistrar = modelRegistrar;
    }

    public BackendTaskFactory getTaskFactory() {
        return this.taskFactory;
    }

    public void setTaskFactory(BackendTaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public void setBackend(Backend backend) {
        this.backend = backend;
    }

    public BackendRegistrarNtro() {
    }

    public BackendRegistrarNtro(ModelRegistrarImpl modelRegistrar, MessageRegistrarNtro messageRegistrarNtro) {
        this.setModelRegistrar(modelRegistrar);
        this.setMessageRegistrar(messageRegistrarNtro);
    }

    @Override
    public void registerBackend(Class<? extends Backend> backendClass) {
        this.backend = (Backend)NtroCoreImpl.factory().newInstance(backendClass);
        this.registerBackendObject(this.backend);
    }

    public void registerBackendObject(Backend backend) {
        if (backend.isLocalBackend()) {
            backend.asLocalBackend().createTasks(this.getTaskFactory().asTasks());
        }
        this.setBackend(backend);
    }

    public void prepareToExecuteTasks() {
        this.getTaskFactory().prepareToExecuteTasks();
    }

    public void executeTasks() {
        this.getTaskFactory().executeTasks();
    }

    public void writeGraph() {
        if (this.getTaskFactory() != null) {
            this.getTaskFactory().writeGraph();
        }
    }

    public void openConnection() {
        if (this.getBackend().isRemoteBackend()) {
            this.getBackend().asRemoteBackend().openConnection();
        }
    }

    public boolean isRemoteBackend() {
        return this.getBackend().isRemoteBackend();
    }

    @Override
    public <B extends Backend> void initializeBackendObject(Class<B> backendClass, Consumer<B> consumer) {
        throw new UnsupportedOperationException();
    }
}

