/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl;

import ca.ntro.app.Ntro;
import ca.ntro.app.NtroClientFx;
import ca.ntro.core.NtroCore;
import ca.ntro.core.services.ExitHandler;
import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_app_fx_impl.executable_spec.ClientFxSpec;
import ca.ntro.ntro_app_fx_impl.frontend.window.WindowFx;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import javafx.application.Application;
import javafx.stage.Stage;

public class AppWrapperFx
extends Application
implements ExitHandler {
    public static Class<? extends NtroClientFx> appClass;
    public static String sessionId;
    public static ClientFxSpec spec;

    public void start(Stage primaryStage) throws Exception {
        NtroCoreImpl.registerAppExitHandler((ExitHandler)this);
        primaryStage.setOnCloseRequest(event -> NtroCore.exit());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> NtroCore.exit()));
        WindowFx window = new WindowFx(primaryStage);
        NtroImpl.registerWindow(window);
        NtroCore.logger().run();
        NtroCore.threads().runInWorkerThread(() -> {
            NtroCore.logger().info("App running. Press Enter or Ctrl+D to close App");
            try {
                System.in.read();
                NtroCore.exit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        try {
            System.out.println("\n\n\n");
            NtroCore.logger().info("Ntro version 0.2");
            NtroCore.logger().info("java version " + System.getProperty("java.version"));
            File javaRootDir = Paths.get(NtroCore.options().javaPath(), new String[0]).toFile();
            File resourcesRootDir = Paths.get(NtroCore.options().resourcesPath(), new String[0]).toFile();
            spec.analyzeSources(resourcesRootDir, javaRootDir);
            spec.registerAppClass(appClass);
            spec.registerSessionId(sessionId);
            spec.registerWindow(window);
            spec.callExecutableCodeAndFillSpec();
            NtroImpl.loadOptionsFile();
            NtroCore.logger().info("locale: '" + String.valueOf(Ntro.currentLocale()) + "'");
            spec.writeSpec();
            spec.createExecutableFromSpec();
            spec.runExecutable();
        }
        catch (Throwable t) {
            t.printStackTrace();
            NtroCoreImpl.logger().fatal(t);
        }
    }

    public void onExit() {
        NtroCore.logger().info("Writing JSON files");
        NtroImpl.models().writeModelFiles();
        NtroImpl.writeSessionFile();
        NtroImpl.writeOptionsFile();
        NtroCore.logger().info("Generating graphs");
        NtroImpl.models().writeGraphs();
        if (!spec.isRemoteBackend()) {
            spec.writeBackendGraph();
        }
        spec.writeFrontendGraph();
    }
}

