/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.services;

import ca.ntro.app.models.Model;
import ca.ntro.app.models.WatchJson;
import ca.ntro.app.models.WriteObjectGraph;
import ca.ntro.app.services.ModelStore;
import ca.ntro.core.NtroCore;
import ca.ntro.core.services.JsonParseError;
import ca.ntro.core.stream.Stream;
import ca.ntro.core.stream.Visitor;
import ca.ntro.core.util.StringUtils;
import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_app_fx_impl.modified.Observable;
import ca.ntro.ntro_app_fx_impl.modified.ObservationNtro;
import ca.ntro.ntro_app_fx_impl.structures.ClassIdMap;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.json.JsonObject;
import ca.ntro.ntro_core_impl.reflection.object_graph.ObjectGraph;
import ca.ntro.ntro_core_impl.stream.StreamNtro;
import java.nio.file.Paths;

public class ModelStoreDefault
implements ModelStore {
    private boolean areDiskOperationsEnabled = true;
    private ClassIdMap<Object, Object> previousModels = new ClassIdMap();
    private ClassIdMap<Object, Object> currentModels = new ClassIdMap();
    private ClassIdMap<Object, Long> modelsLastModified = new ClassIdMap();

    @Override
    public <M extends Model> M load(Class<?> modelClass, String modelId) {
        Model model = (Model)this.currentModels.get(modelClass, modelId);
        if (model == null) {
            model = this.loadFromFile(modelClass, modelId);
        }
        if (model == null) {
            model = (Model)NtroCore.factory().newInstance(modelClass);
        }
        try {
            this.previousModels.put(modelClass, modelId, model);
        }
        catch (Throwable t) {
            NtroCore.logger().fatal("cannnot clone model " + modelClass.getSimpleName(), t);
        }
        this.currentModels.put(modelClass, modelId, model);
        return (M)model;
    }

    @Override
    public <M extends Model> M load(Class<?> modelClass) {
        return this.load(modelClass, null);
    }

    private synchronized <M extends Model> M loadFromJsonString(Class<?> modelClass, String modelId, String jsonString) {
        Model model = null;
        try {
            JsonObject jsonObject = NtroCore.json().fromJsonString(jsonString);
            model = (Model)NtroCoreImpl.reflection().graphFromJsonObject(jsonObject).buildObject();
        }
        catch (JsonParseError t) {
            NtroCore.logger().warning("JsonParseError for " + this.filePathFromClass(modelClass, modelId).toString());
        }
        catch (Throwable t) {
            NtroCore.logger().warning("Loading error for: " + this.filePathFromClass(modelClass, modelId).toString() + ". Using empty model");
            model = (Model)NtroCore.factory().newInstance(modelClass);
        }
        return (M)model;
    }

    private synchronized <M extends Model> M loadFromFile(Class<?> modelClass, String modelId) {
        Model model = null;
        String filePath = this.filePathFromClass(modelClass, modelId);
        if (NtroCore.storage().ifFileExists(filePath)) {
            String jsonString = NtroCore.storage().readTextFile(filePath);
            model = (Model)this.loadFromJsonString(modelClass, modelId, jsonString);
        } else {
            NtroCore.logger().warning("Json file not found for: " + this.filePathFromClass(modelClass, modelId).toString() + ". Using empty model");
            model = (Model)NtroCore.factory().newInstance(modelClass);
        }
        return (M)model;
    }

    private String filePathFromClass(Class<?> modelClass, String modelId) {
        String path = null;
        path = StringUtils.isNullOrEmpty((String)modelId) ? Paths.get(NtroCoreImpl.options().modelsPath(), NtroCoreImpl.reflection().simpleName(modelClass) + ".json").toAbsolutePath().toString() : Paths.get(NtroCoreImpl.options().modelsPath(), NtroCoreImpl.reflection().simpleName(modelClass), modelId + ".json").toAbsolutePath().toString();
        return path;
    }

    @Override
    public void save(Class<?> modelClass, Object model) {
        this.save(modelClass, null, model);
    }

    @Override
    public void save(Class<?> modelClass, String modelId, Object model) {
        Object previousModel = this.previousModels.get(modelClass, modelId);
        if (model instanceof WatchJson && this.areDiskOperationsEnabled) {
            this.writeModelFile(this.filePathFromClass(modelClass, modelId), modelClass, modelId, model);
        }
        this.pushObservation(modelClass, modelId, previousModel, model);
    }

    private synchronized void writeModelFile(String filePath, Class<?> modelClass, String modelId, Object model) {
        ObjectGraph graph = NtroCoreImpl.reflection().graphFromObject(model);
        JsonObject jsonObject = graph.buildJsonObject();
        String jsonString = jsonObject.toJsonString(true);
        long lastModified = NtroCore.storage().writeTextFileBlocking(filePath, jsonString);
        this.modelsLastModified.put(modelClass, modelId, lastModified);
    }

    private synchronized void writeModelFileBlocking(String filePath, Class<?> modelClass, String modelId, Object model) {
        ObjectGraph graph = NtroCoreImpl.reflection().graphFromObject(model);
        JsonObject jsonObject = graph.buildJsonObject();
        String jsonString = jsonObject.toJsonString(true);
        long lastModified = NtroCore.storage().writeTextFileBlocking(filePath, jsonString);
        this.modelsLastModified.put(modelClass, modelId, lastModified);
    }

    @Override
    public void writeModelFiles() {
        this.currentModels.entries().forEach(entry -> {
            Class modelClass = entry.entryClass();
            String modelId = entry.entryId();
            Object model = entry.value();
            String filePath = this.filePathFromClass(modelClass, modelId);
            this.writeModelFileBlocking(filePath, modelClass, modelId, model);
        });
    }

    @Override
    public void writeGraphs() {
        this.currentModels.entries().forEach(entry -> {
            Object model = entry.value();
            if (model instanceof WriteObjectGraph) {
                this.writeModelGraph(entry.entryClass(), entry.entryId(), model);
            }
        });
    }

    private void writeModelGraph(Class<?> modelClass, String modelId, Object model) {
        ObjectGraph graph = NtroCoreImpl.reflection().graphFromObject(model, this.graphName(modelClass, modelId));
        graph.write(NtroCoreImpl.graphWriter());
    }

    private String graphName(Class<?> modelClass, String modelId) {
        Object graphName = NtroCoreImpl.reflection().simpleName(modelClass);
        if (!StringUtils.isNullOrEmpty((String)modelId)) {
            graphName = (String)graphName + "_" + modelId;
        }
        return graphName;
    }

    @Override
    public void watch(Class<? extends Observable> modelClass, String modelId) {
        String filePath = this.filePathFromClass(modelClass, modelId);
        Object model = this.load(modelClass, modelId);
        this.createModelFileIfNeeded(filePath, modelClass, modelId, model);
        this.pushFirstObservation(modelClass, modelId);
        if (NtroCoreImpl.reflection().ifClassImplements(modelClass, WatchJson.class)) {
            NtroCore.storage().watchFileContent(filePath, (lastModified, jsonString) -> this.onModelFileChanged(modelClass, modelId, lastModified, jsonString));
        }
    }

    @Override
    public void watch(Class<? extends Observable> modelClass) {
        this.watch(modelClass, null);
    }

    private void createModelFileIfNeeded(String filePath, Class<?> modelClass, String modelId, Object model) {
        if (!NtroCore.storage().ifFileExists(filePath)) {
            this.writeModelFile(filePath, modelClass, modelId, model);
        }
    }

    private void onModelFileChanged(Class<? extends Observable> modelClass, String modelId, long lastModified, String jsonString) {
        Long previousLastModified = this.modelsLastModified.get(modelClass, modelId);
        if (previousLastModified == null || lastModified > previousLastModified) {
            this.modelsLastModified.put(modelClass, modelId, lastModified);
            Object previousModel = this.currentModels.get(modelClass, modelId);
            Object currentModel = this.loadFromJsonString(modelClass, modelId, jsonString);
            if (currentModel != null) {
                this.currentModels.put(modelClass, modelId, currentModel);
                this.pushObservation(modelClass, modelId, previousModel, currentModel);
            }
        }
    }

    private void pushFirstObservation(Class<? extends Observable> modelClass, String modelId) {
        Object previousModel = NtroCore.factory().newInstance(modelClass);
        Object currentModel = this.load(modelClass, modelId);
        this.pushObservation(modelClass, modelId, previousModel, currentModel);
    }

    @Override
    public ObservationNtro getCurrentModelObservation(Class<? extends Observable> modelClass, String modelId) {
        Object previousModel = this.previousModels.get(modelClass, modelId);
        Object currentModel = this.load(modelClass, modelId);
        return this.createObservation(modelId, previousModel, currentModel);
    }

    private ObservationNtro createObservation(String modelId, Object previousModel, Object currentModel) {
        ObservationNtro<Observable> observation = new ObservationNtro<Observable>();
        observation.setId(modelId);
        observation.setPreviousValue((Observable)previousModel);
        observation.setCurrentValue((Observable)currentModel);
        return observation;
    }

    private void pushObservation(Class<?> modelClass, String modelId, Object previousModel, Object currentModel) {
        if (previousModel != null) {
            ObservationNtro observation = this.createObservation(modelId, previousModel, currentModel);
            NtroImpl.messageService().receiveObservationFromServer(modelClass, modelId, observation);
            NtroImpl.messageService().pushObservationToClients(modelClass, modelId, observation);
        }
    }

    @Override
    public Stream<Model> modelStream() {
        return new StreamNtro<Model>(){

            public void forEach_(Visitor<Model> visitor) throws Throwable {
                ModelStoreDefault.this.currentModels.values().forEach(model -> visitor.visit((Object)((Model)model)));
            }
        };
    }

    @Override
    public void suspendDiskOperations() {
        this.areDiskOperationsEnabled = false;
    }

    @Override
    public void resumeDiskOperations() {
        this.areDiskOperationsEnabled = true;
    }

    @Override
    public <M extends Model> void delete(Class<M> modelClass, String modelId) {
        this.deleteModelFile(modelClass, modelId);
    }

    @Override
    public <M extends Model> void delete(Class<M> modelClass) {
        this.deleteModelFile(modelClass);
    }

    private synchronized void deleteModelFile(Class<?> modelClass, String modelId) {
        String filePath = this.filePathFromClass(modelClass, modelId);
        if (NtroCore.storage().ifFileExists(filePath)) {
            NtroCore.storage().deleteTextFile(filePath);
        }
    }

    private synchronized void deleteModelFile(Class<?> modelClass) {
        this.deleteModelFile(modelClass, null);
    }
}

