/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.services;

import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.services.LoggerTasks;
import javafx.fxml.LoadException;

public class LoggerFx
extends LoggerTasks {
    protected void fatalDialog(String message) {
        NtroCoreImpl.threads().runOnMainThread(() -> {
            NtroImpl.window().show();
            NtroImpl.window().displayFatalErrorMessage(message);
        });
    }

    private void swingErrorDialog(String message) {
        String thisVmClasspath = System.getProperty("java.class.path");
        String thisVmModulepath = System.getProperty("jdk.module.path");
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] args = new String[]{"java", "-Dsun.java2d.opengl=true", "-Dfile.encoding=UTF-8", "-Duser.country=CA", "-Duser.language=fr", "-Duser.variant", "-cp", thisVmClasspath, "--module-path", thisVmModulepath, "--module", "ca.ntro.fx/ca.ntro.app.fatal_dialog.FatalDialogSwing", message};
            Process process = runtime.exec(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void printArgs(String[] args) {
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            builder.append(" \"");
            builder.append(arg);
            builder.append("\"");
        }
        System.out.println(builder.toString());
    }

    public void fatal(Throwable t) {
        if (t instanceof LoadException) {
            this.memorizeFatalHasNowOccured();
            this.fatalLoadException((LoadException)t);
        } else {
            super.fatal(t);
        }
    }

    private void fatalLoadException(LoadException e) {
        this.logException((Throwable)e);
        Object message = "";
        if (e.getMessage() != null) {
            try {
                String filepathAndLineNumber = e.getMessage().trim();
                String[] segments = filepathAndLineNumber.split(":");
                String filepath = filepathAndLineNumber;
                int lineNumber = 0;
                if (segments.length >= 2) {
                    filepath = segments[segments.length - 2];
                    lineNumber = Integer.parseInt(segments[segments.length - 1]);
                }
                String filename = filepath;
                String messagePrefix = "";
                segments = filepath.contains("/") ? filepath.split("/") : filepath.split("\\");
                if (segments.length > 0) {
                    filename = segments[segments.length - 1];
                }
                if (segments.length > 1) {
                    messagePrefix = segments[0];
                    messagePrefix = messagePrefix.replaceAll(System.lineSeparator(), "");
                }
                message = lineNumber == 0 ? (String)message + "(" + filename + ")" : (String)message + "(" + filename + ":" + lineNumber + ")";
                message = (String)message + " " + messagePrefix;
            }
            catch (Throwable t) {
                message = e.getMessage();
            }
        }
        if (e.getCause() != null) {
            Throwable cause = e.getCause();
            message = cause instanceof ClassNotFoundException ? (String)message + " class not found: " + cause.getMessage() : (String)message + "\n\t" + cause.getClass().getSimpleName() + " " + cause.getMessage();
        }
        this.finalizeFatal((String)message);
    }
}

