/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl;

import ca.ntro.app.events.Event;
import ca.ntro.app.services.EventService;
import ca.ntro.app.services.MessageService;
import ca.ntro.app.services.ModelStore;
import ca.ntro.app.services.Window;
import ca.ntro.app.session.Session;
import ca.ntro.app.session.SessionAccessor;
import ca.ntro.core.services.JsonParseError;
import ca.ntro.ntro_app_fx_impl.NtroMode;
import ca.ntro.ntro_app_fx_impl.NtroOs;
import ca.ntro.ntro_app_fx_impl.options.OptionsImpl;
import ca.ntro.ntro_app_fx_impl.services.EventServiceNtro;
import ca.ntro.ntro_app_fx_impl.services.MessageServiceJdk;
import ca.ntro.ntro_app_fx_impl.services.ModelStoreDefault;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.json.JsonObject;
import java.nio.file.Path;
import java.nio.file.Paths;

public class NtroImpl {
    private static EventService eventService = new EventServiceNtro();
    private static MessageService messageService = new MessageServiceJdk();
    private static ModelStore modelStore = new ModelStoreDefault();
    private static Window window = null;
    private static Session session = new Session();
    private static OptionsImpl options;
    private static NtroMode ntroMode;
    private static NtroOs ntroOs;

    static void registerEventService(EventService eventService) {
        NtroImpl.eventService = eventService;
    }

    public static EventService eventService() {
        return eventService;
    }

    public static <E extends Event> E newEvent(Class<E> eventClass) {
        return eventService.newEvent(eventClass);
    }

    public static void registerMessageService(MessageService messageService) {
        NtroImpl.messageService = messageService;
    }

    public static MessageService messageService() {
        return messageService;
    }

    static void registerModelStore(ModelStore modelStore) {
        NtroImpl.modelStore = modelStore;
    }

    public static ModelStore models() {
        return modelStore;
    }

    public static void assertNotNull(String message, Object value) {
        NtroCoreImpl.stackAnalyzer.incrementCallDistanceForCurrentThread();
        NtroCoreImpl.asserter().assertNotNull(message, value);
        NtroCoreImpl.stackAnalyzer.decrementCallDistanceForCurrentThread();
    }

    public static void assertNotNull(Object value) {
        NtroCoreImpl.stackAnalyzer.incrementCallDistanceForCurrentThread();
        NtroCoreImpl.asserter().assertNotNull(value);
        NtroCoreImpl.stackAnalyzer.decrementCallDistanceForCurrentThread();
    }

    public static void registerWindow(Window window) {
        NtroImpl.window = window;
    }

    public static Window window() {
        return window;
    }

    public static void registerSession(Session session) {
        NtroImpl.session = session;
    }

    public static <S extends Session> S session() {
        return (S)session;
    }

    public static void writeSessionFile() {
        if (SessionAccessor.isNamedSession(session)) {
            String sessionText = NtroCoreImpl.reflection().toJsonObject((Object)session).toJsonString(true);
            String sessionsPath = NtroImpl.options().coreOptions().sessionsPath();
            Path sessionFilePath = Paths.get(sessionsPath, session.sessionId() + ".json");
            NtroCoreImpl.storage().writeTextFileBlocking(sessionFilePath.toAbsolutePath().toString(), sessionText);
        }
    }

    public static void registerOptions(OptionsImpl options) {
        NtroImpl.options = options;
    }

    public static OptionsImpl options() {
        return options;
    }

    public static void writeOptionsFile() {
        if (SessionAccessor.isNamedSession(session)) {
            String optionsText = NtroCoreImpl.reflection().toJsonObject((Object)options).toJsonString(true);
            String optionsPath = NtroImpl.options().coreOptions().optionsPath();
            Path optionsFilePath = Paths.get(optionsPath, session.sessionId() + ".json");
            NtroCoreImpl.storage().writeTextFileBlocking(optionsFilePath.toAbsolutePath().toString(), optionsText);
        }
    }

    public static void loadOptionsFile() {
        if (SessionAccessor.isNamedSession(session)) {
            String sessionId = session.sessionId();
            String optionsPath = NtroImpl.options().coreOptions().optionsPath();
            Path optionsFilepath = Paths.get(optionsPath, sessionId + ".json");
            String rawOptionsFilepath = optionsFilepath.toAbsolutePath().toString();
            if (NtroCoreImpl.storage().ifFileExists(rawOptionsFilepath)) {
                String optionsText = NtroCoreImpl.storage().readTextFile(rawOptionsFilepath);
                try {
                    JsonObject optionsJson = NtroCoreImpl.json().fromJsonString(optionsText);
                    options = (OptionsImpl)NtroCoreImpl.reflection().fromJsonObject(optionsJson);
                    options.resolvePaths();
                }
                catch (JsonParseError e) {
                    NtroCoreImpl.logger().warning("JsonParseError for " + rawOptionsFilepath);
                }
            }
            NtroCoreImpl.logger().info("options: " + sessionId);
        } else {
            NtroCoreImpl.logger().info("default options");
        }
    }

    static void registerNtroMode(NtroMode ntroMode) {
        NtroImpl.ntroMode = ntroMode;
    }

    public static boolean isApp() {
        return ntroMode == NtroMode.APP;
    }

    public static boolean isClient() {
        return ntroMode == NtroMode.CLIENT;
    }

    public static boolean isServer() {
        return ntroMode == NtroMode.SERVER;
    }

    public static NtroOs ntroOs() {
        return ntroOs;
    }

    public static boolean isWindows() {
        return ntroOs == NtroOs.WINDOWS;
    }

    public static boolean isLinux() {
        return ntroOs == NtroOs.LINUX;
    }

    public static boolean isMac() {
        return ntroOs == NtroOs.MAC;
    }

    static {
        ntroMode = NtroMode.APP;
        ntroOs = NtroOs.WINDOWS;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("linux")) {
            ntroOs = NtroOs.LINUX;
        } else if (osName.contains("mac")) {
            ntroOs = NtroOs.MAC;
        }
    }
}

