/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.app.world2d;

import ca.ntro.app.Ntro;
import ca.ntro.app.fx.controls.ResizableWorld2dCanvasFx;
import ca.ntro.app.fx.controls.World2dMouseEventFx;
import ca.ntro.app.models.ModelValue;
import ca.ntro.app.world2d.Object2dFx;
import ca.ntro.core.NtroCore;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.AnonymousRegion2dNtro;
import ca.ntro.ntro_core_impl.exceptions.Break;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public abstract class World2dFx
implements ModelValue {
    public static final int DEFAULT_Z_INDEX = 1;
    public static final double DEFAULT_WIDTH = 640.0;
    public static final double DEFAULT_HEIGHT = 360.0;
    private final double INTERSECT_EPSILON = 5.0;
    private double width = 640.0;
    private double height = 360.0;
    private Map<Integer, Set<Object2dFx>> objectsByZIndex = new HashMap<Integer, Set<Object2dFx>>();
    private List<Integer> populatedZIndices = new ArrayList<Integer>();
    private Map<String, Object2dFx> objectsById = new HashMap<String, Object2dFx>();
    private boolean clipAtViewport = true;
    private int iterationsInProgress = 0;

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public boolean getClipAtViewport() {
        return this.clipAtViewport;
    }

    public void setClipAtViewport(boolean clipAtViewport) {
        this.clipAtViewport = clipAtViewport;
    }

    protected abstract void onMouseEventNotConsumed(World2dMouseEventFx var1);

    public void initializeFx() {
        this.forEachObject(true, obj -> obj.initializeFx());
    }

    public <O extends Object2dFx> O getObject2d(Class<O> cls, String id) {
        return (O)this.objectsById.get(id);
    }

    public Object2dFx getObject2d(String id) {
        return this.objectsById.get(id);
    }

    public void removeObject2d(String id) {
        this.checkContext("removeObject2d");
        this.checkId(id, "removeObject2d");
        Object2dFx obj = this.objectsById.get(id);
        if (obj != null) {
            this.objectsById.remove(id);
            Integer zIndex = obj.zIndex();
            Set<Object2dFx> objects = this.objectsByZIndex.get(zIndex);
            if (objects != null) {
                objects.remove(obj);
                if (objects.isEmpty()) {
                    this.objectsByZIndex.remove(zIndex, objects);
                    this.populatedZIndices.remove(zIndex);
                }
            }
        }
    }

    private void checkContext(String methodName) {
        if (!NtroCore.threads().isMainThread()) {
            Ntro.logger().fatal(String.format("Must call %s.%s from the main thread (typically from a task)", World2dFx.class.getSimpleName(), methodName));
        }
        if (this.iterationsInProgress > 0) {
            Ntro.logger().fatal(String.format("Must not call World2dFx.removeObject2d from onTimePasses, drawOnWorld, forEachObject or reduceObjects", World2dFx.class.getSimpleName(), methodName));
        }
    }

    public void clearObjects() {
        this.checkContext("clearObjects");
        HashSet<String> idsOfObjectsToRemove = new HashSet<String>();
        idsOfObjectsToRemove.addAll(this.objectsById.keySet());
        this.removeObjectsWithIdIn(idsOfObjectsToRemove);
    }

    public void removeObjectsWithIdIn(Set<String> idsOfObjectsToRemove) {
        this.checkContext("removeObjectsWithIdIn");
        for (String id : idsOfObjectsToRemove) {
            this.removeObject2d(id);
        }
    }

    public void removeObjectsWithIdNotIn(Set<String> idsOfObjectToKeep) {
        this.checkContext("removeObjectWithIdNotIn");
        HashSet<String> idsToRemove = new HashSet<String>();
        for (String candidateId : this.objectsById.keySet()) {
            if (idsOfObjectToKeep.contains(candidateId)) continue;
            idsToRemove.add(candidateId);
        }
        this.removeObjectsWithIdIn(idsToRemove);
    }

    public void addObject2d(Object2dFx object2d) {
        this.addObject2d(Ntro.random().nextId(5), 1, object2d);
    }

    public void addObject2d(String id, Object2dFx object2d) {
        this.checkId(id, "addObject2d");
        this.addObject2d(id, 1, object2d);
    }

    private void checkId(String id, String methodName) {
        if (id == null || id.isBlank() || id.isEmpty()) {
            Ntro.logger().fatal(String.format("%s.%s: '%s' is not a valid id", World2dFx.class.getSimpleName(), methodName, id));
        }
    }

    public void addObject2d(String id, int zIndex, Object2dFx object2d) {
        this.checkContext("addObject2d");
        this.checkId(id, "addObject2d");
        object2d.setWorld2d(this);
        object2d.setId(id);
        object2d.setZIndex(zIndex);
        object2d.onAddedToWorld();
        this.objectsById.put(id, object2d);
        Set<Object2dFx> objects = this.objectsByZIndex.get(zIndex);
        if (objects == null) {
            objects = new HashSet<Object2dFx>();
            this.objectsByZIndex.put(zIndex, objects);
        }
        objects.add(object2d);
        this.insertZIndex(zIndex);
    }

    private void insertZIndex(int zIndex) {
        int begin = 0;
        int end = this.populatedZIndices.size() - 1;
        while (begin <= end) {
            int middle = (begin + end) / 2;
            if (zIndex < this.populatedZIndices.get(middle)) {
                end = middle - 1;
                continue;
            }
            if (zIndex > this.populatedZIndices.get(middle)) {
                begin = middle + 1;
                continue;
            }
            return;
        }
        this.populatedZIndices.add(begin, zIndex);
    }

    protected void forEachObject(boolean iterateInDrawOrder, Consumer<Object2dFx> consummer) {
        ++this.iterationsInProgress;
        if (iterateInDrawOrder) {
            try {
                for (int zIndex : this.populatedZIndices) {
                    Set<Object2dFx> objects = this.objectsByZIndex.get(zIndex);
                    for (Object2dFx obj : objects) {
                        consummer.accept(obj);
                    }
                }
            }
            catch (Break break_) {}
        } else {
            try {
                for (int i = this.populatedZIndices.size() - 1; i >= 0; --i) {
                    Integer zIndex = this.populatedZIndices.get(i);
                    Set<Object2dFx> objects = this.objectsByZIndex.get(zIndex);
                    for (Object2dFx obj : objects) {
                        consummer.accept(obj);
                    }
                }
            }
            catch (Break break_) {
                // empty catch block
            }
        }
        --this.iterationsInProgress;
    }

    protected <O> O reduceObjects(boolean iterateInDrawOrder, O initialValue, BiFunction<O, Object2dFx, O> consummer) {
        O result = initialValue;
        ++this.iterationsInProgress;
        if (iterateInDrawOrder) {
            try {
                for (int zIndex : this.populatedZIndices) {
                    Set<Object2dFx> objects = this.objectsByZIndex.get(zIndex);
                    for (Object2dFx obj : objects) {
                        result = consummer.apply(result, obj);
                    }
                }
            }
            catch (Break break_) {}
        } else {
            try {
                for (int i = this.populatedZIndices.size() - 1; i >= 0; --i) {
                    Integer zIndex = this.populatedZIndices.get(i);
                    Set<Object2dFx> objects = this.objectsByZIndex.get(zIndex);
                    for (Object2dFx obj : objects) {
                        result = consummer.apply(result, obj);
                    }
                }
            }
            catch (Break break_) {
                // empty catch block
            }
        }
        --this.iterationsInProgress;
        return result;
    }

    public void drawOn(ResizableWorld2dCanvasFx canvas) {
        AnonymousRegion2dNtro viewport = new AnonymousRegion2dNtro(canvas.getViewportTopLeftX(), canvas.getViewportTopLeftY(), canvas.getViewportWidth(), canvas.getViewportHeight());
        canvas.drawOnWorld(gc -> this.forEachObject(true, obj -> {
            if (!this.clipAtViewport || obj.intersectsWith(viewport, 5.0)) {
                obj.drawOnWorld(gc);
            }
        }));
    }

    public void onTimePasses(double secondsElapsed) {
        this.forEachObject(true, obj -> obj.onTimePasses(secondsElapsed));
    }

    public void dispatchMouseEvent(World2dMouseEventFx world2dMouseEventFx) {
        double worldX = world2dMouseEventFx.worldX();
        double worldY = world2dMouseEventFx.worldY();
        boolean iterateInDrawOrder = false;
        boolean consumed = false;
        if (!(consumed = this.reduceObjects(iterateInDrawOrder, consumed, (accumulator, obj) -> {
            if (accumulator.booleanValue()) {
                throw new Break();
            }
            if (obj.collidesWith(worldX - 5.0, worldY - 5.0, 10.0, 10.0)) {
                accumulator = accumulator != false || obj.onMouseEvent(world2dMouseEventFx);
            }
            return accumulator;
        }).booleanValue())) {
            this.onMouseEventNotConsumed(world2dMouseEventFx);
        }
    }
}

