/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.app.fx.controls;

import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public abstract class SimpleFlexBox
extends StackPane {
    private HBox hbox = new HBox();
    private VBox vbox = new VBox();
    private Pane currentPane = this;
    private double gap = 200.0;
    private double prefWidth = -1.0;

    public SimpleFlexBox() {
        this.initializeFlexBox();
        this.initialize();
    }

    protected double getGap() {
        return this.gap;
    }

    protected void setGap(double gap) {
        this.gap = gap;
    }

    protected abstract void initialize();

    private void initializeFlexBox() {
        this.getChildren().add((Object)this.vbox);
        this.getChildren().add((Object)this.hbox);
        this.hbox.setAlignment(Pos.CENTER);
        this.vbox.setAlignment(Pos.CENTER);
        this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (oldValue.doubleValue() == 0.0) {
                    SimpleFlexBox.this.prefWidth = 0.0;
                    for (Node child : SimpleFlexBox.this.getChildren()) {
                        SimpleFlexBox.this.prefWidth += child.prefWidth(0.0);
                    }
                }
            }
        });
    }

    protected void layoutChildren() {
        if (this.prefWidth == -1.0) {
            return;
        }
        if (this.currentPane != this.vbox && this.getWidth() < this.prefWidth + this.gap) {
            this.toVBox();
        } else if (this.currentPane != this.hbox && this.getWidth() >= this.prefWidth + this.gap) {
            this.toHBox();
        }
        super.layoutChildren();
    }

    private void moveNodes(Pane from, Pane to, Pos alignment) {
        ArrayList<Node> toMove = new ArrayList<Node>();
        for (Node child : from.getChildren()) {
            if (child == this.hbox || child == this.vbox || child == this.currentPane) continue;
            toMove.add(child);
        }
        for (Node child : toMove) {
            from.getChildren().remove((Object)child);
            to.getChildren().add((Object)child);
            this.setNodeAlignment(child, alignment);
        }
    }

    private void setNodeAlignment(Node node, Pos alignment) {
        if (node instanceof VBox) {
            ((VBox)node).setAlignment(alignment);
        } else if (node instanceof HBox) {
            ((HBox)node).setAlignment(alignment);
        } else if (node instanceof StackPane) {
            ((StackPane)node).setAlignment(alignment);
        }
    }

    private void toVBox() {
        this.moveNodes(this.currentPane, (Pane)this.vbox, Pos.CENTER);
        this.vbox.toFront();
        this.currentPane = this.vbox;
        this.onVBox();
    }

    protected abstract void onVBox();

    private void toHBox() {
        this.moveNodes(this.currentPane, (Pane)this.hbox, Pos.CENTER_LEFT);
        this.hbox.toFront();
        this.currentPane = this.hbox;
        this.onHBox();
    }

    protected abstract void onHBox();
}

