/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.app.fx.controls;

import ca.ntro.app.fx.controls.AspectMode;
import ca.ntro.app.fx.controls.ClipMode;
import ca.ntro.app.fx.controls.DrawListener;
import ca.ntro.app.fx.controls.DrawingLambdaFx;
import ca.ntro.app.fx.controls.PositionMode;
import ca.ntro.app.fx.controls.ResizeMode;
import ca.ntro.app.fx.controls.World2dMouseEventFx;
import ca.ntro.app.fx.controls.World2dMouseEventListener;
import java.util.Set;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;

public class ResizableWorld2dCanvasFx
extends Pane {
    private Canvas rawCanvas;
    private GraphicsContext rawGc;
    private double epsilon = 0.1;
    private DrawListener drawListener;
    private EventHandler<MouseEvent> mouseEventHandlerFx;
    private Affine drawOnViewscreenTransform = this.defaultTransform();
    private Affine drawOnViewportTransform = this.defaultTransform();
    private Affine drawOnWorldTransform = this.defaultTransform();
    private PositionMode positionMode = PositionMode.CENTER;
    private ResizeMode resizeMode = ResizeMode.SCALE;
    private AspectMode aspectMode = AspectMode.PRESERVE_ASPECT_RATIO;
    private Set<ClipMode> clipModes = Set.of(ClipMode.CLIP_AT_VIEWPORT);
    private double worldWidth = 640.0;
    private double worldHeight = 360.0;
    private double viewportWidth = 640.0;
    private double viewportHeight = 360.0;
    private double viewportTopLeftX = 0.0;
    private double viewportTopLeftY = 0.0;
    private double viewscreenWidth = 640.0;
    private double viewscreenHeight = 360.0;
    private double viewscreenTopLeftX = 0.0;
    private double viewscreenTopLeftY = 0.0;

    protected double getEpsilon() {
        return this.epsilon;
    }

    protected void setEpsilon(int epsilon) {
        this.epsilon = epsilon;
    }

    public PositionMode getPositionMode() {
        return this.positionMode;
    }

    public void setPositionMode(PositionMode positionMode) {
        this.positionMode = positionMode;
    }

    public ResizeMode getResizeMode() {
        return this.resizeMode;
    }

    public void setResizeMode(ResizeMode resizeMode) {
        this.resizeMode = resizeMode;
    }

    public AspectMode getAspectMode() {
        return this.aspectMode;
    }

    public void setAspectMode(AspectMode aspectMode) {
        this.aspectMode = aspectMode;
    }

    public Set<ClipMode> getClipModes() {
        return this.clipModes;
    }

    public void setClipModes(Set<ClipMode> clipModes) {
        this.clipModes = clipModes;
    }

    public double getWorldWidth() {
        return this.worldWidth;
    }

    public double getCanvasWidth() {
        return this.getWidth();
    }

    public double getCanvasHeight() {
        return this.getHeight();
    }

    public void setWorldWidth(double worldWidth) {
        this.worldWidth = worldWidth;
        this.recomputeTransforms();
    }

    public double getWorldHeight() {
        return this.worldHeight;
    }

    public void setWorldHeight(double worldHeight) {
        this.worldHeight = worldHeight;
        this.recomputeTransforms();
    }

    public double getViewportWidth() {
        return this.viewportWidth;
    }

    public void setViewportWidth(double viewportWidth) {
        this.viewportWidth = viewportWidth;
        this.recomputeTransforms();
    }

    public double getViewportHeight() {
        return this.viewportHeight;
    }

    public void setViewportHeight(double viewportHeight) {
        this.viewportHeight = viewportHeight;
        this.recomputeTransforms();
        this.invalidate();
    }

    public double getViewportTopLeftX() {
        return this.viewportTopLeftX;
    }

    public void setViewportTopLeftX(double viewportTopLeftX) {
        this.viewportTopLeftX = viewportTopLeftX;
        this.recomputeTransforms();
        this.invalidate();
    }

    public double getViewportTopLeftY() {
        return this.viewportTopLeftY;
    }

    public void setViewportTopLeftY(double viewportTopLeftY) {
        this.viewportTopLeftY = viewportTopLeftY;
        this.recomputeTransforms();
        this.invalidate();
    }

    public double getViewscreenWidth() {
        return this.viewscreenWidth;
    }

    public void setViewscreenWidth(double viewscreenWidth) {
        this.viewscreenWidth = viewscreenWidth;
        this.recomputeTransforms();
        this.invalidate();
    }

    public double getViewscreenHeight() {
        return this.viewscreenHeight;
    }

    public void setViewscreenHeight(double viewscreenHeight) {
        this.viewscreenHeight = viewscreenHeight;
        this.recomputeTransforms();
        this.invalidate();
    }

    public double getViewscreenTopLeftX() {
        return this.viewscreenTopLeftX;
    }

    public void setViewscreenTopLeftX(double viewscreenTopLeftX) {
        this.viewscreenTopLeftX = viewscreenTopLeftX;
        this.recomputeTransforms();
        this.invalidate();
    }

    public double getViewscreenTopLeftY() {
        return this.viewscreenTopLeftY;
    }

    public void setViewscreenTopLeftY(double viewscreenTopLeftY) {
        this.viewscreenTopLeftY = viewscreenTopLeftY;
        this.recomputeTransforms();
        this.invalidate();
    }

    public void setInitialWorldSize(double worldWidth, double worldHeight) {
        this.setWorldWidth(worldWidth);
        this.setWorldHeight(worldHeight);
        this.setViewportWidth(worldWidth);
        this.setViewportHeight(worldHeight);
    }

    public ResizableWorld2dCanvasFx() {
        this.setPrefWidth(this.getWorldWidth());
        this.setPrefHeight(this.getWorldHeight());
        this.initializeCanvas();
        Platform.runLater(() -> {
            this.initialize();
            this.invalidate();
        });
    }

    protected void initialize() {
    }

    public void onRedraw(DrawListener drawListener) {
        this.drawListener = drawListener;
    }

    public void onMouseEvent(final World2dMouseEventListener mouseEventListener) {
        if (this.mouseEventHandlerFx != null) {
            this.rawCanvas.addEventFilter(MouseEvent.ANY, this.mouseEventHandlerFx);
        }
        this.mouseEventHandlerFx = new EventHandler<MouseEvent>(){
            final /* synthetic */ ResizableWorld2dCanvasFx this$0;
            {
                this.this$0 = this$0;
            }

            public void handle(MouseEvent rawEvent) {
                mouseEventListener.onMouseEvent(new World2dMouseEventFx(rawEvent, this.this$0));
            }
        };
        this.rawCanvas.addEventFilter(MouseEvent.ANY, this.mouseEventHandlerFx);
    }

    private void initializeCanvas() {
        this.installRawCanvas();
        this.installWidthObserver();
        this.installHeightObserver();
    }

    private void installRawCanvas() {
        this.rawCanvas = new Canvas();
        this.rawGc = this.rawCanvas.getGraphicsContext2D();
        this.getChildren().add((Object)this.rawCanvas);
        this.rawCanvas.setWidth(this.getWorldWidth());
        this.rawCanvas.setHeight(this.getWorldHeight());
    }

    private void installWidthObserver() {
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.resizeRawCanvasIfNeeded());
    }

    private void installHeightObserver() {
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.resizeRawCanvasIfNeeded());
    }

    private void resizeRawCanvasIfNeeded() {
        if (this.shouldResizeRawCanvas()) {
            this.resizeRawCanvas();
        }
    }

    private boolean shouldResizeRawCanvas() {
        return Math.abs(this.getWidth() - this.rawCanvas.getWidth()) > this.epsilon || Math.abs(this.getHeight() - this.rawCanvas.getHeight()) > this.epsilon;
    }

    private void resizeRawCanvas() {
        this.rawCanvas.setWidth(this.getWidth());
        this.rawCanvas.setHeight(this.getHeight());
        if (this.sizesAreValid()) {
            this.resizeRelocateRegions();
            this.recomputeTransforms();
        }
        this.invalidate();
    }

    public void invalidate() {
        if (this.drawListener != null) {
            this.clearCanvas();
            this.drawListener.draw();
        }
    }

    public void clearCanvas() {
        this.rawGc.clearRect(0.0, 0.0, this.rawCanvas.getWidth(), this.rawCanvas.getHeight());
    }

    private Affine defaultTransform() {
        Affine defaultTransform = new Affine();
        return defaultTransform;
    }

    private void resizeRelocateRegions() {
        if (this.aspectMode == AspectMode.PRESERVE_ASPECT_RATIO) {
            this.resizeRelocateRegionsPreserveAspectRatio();
        } else {
            this.resizeRelocateRegionsIgnoreAspectRatio();
        }
    }

    private void resizeRelocateRegionsIgnoreAspectRatio() {
        this.viewscreenWidth = this.rawCanvas.getWidth();
        this.viewscreenHeight = this.rawCanvas.getHeight();
        this.viewscreenTopLeftX = 0.0;
        this.viewscreenTopLeftY = 0.0;
    }

    private void resizeRelocateRegionsPreserveAspectRatio() {
        double viewportAspectRatio = this.viewportWidth / this.viewportHeight;
        double rawAspectRatio = this.rawCanvas.getWidth() / this.rawCanvas.getHeight();
        if (viewportAspectRatio > rawAspectRatio) {
            this.viewscreenWidth = this.rawCanvas.getWidth();
            this.viewscreenHeight = this.viewscreenWidth / viewportAspectRatio;
            this.viewscreenTopLeftX = 0.0;
            switch (this.positionMode) {
                case TOP_CENTER: 
                case TOP_LEFT: 
                case TOP_RIGHT: {
                    this.viewscreenTopLeftY = 0.0;
                    break;
                }
                case BOTTOM_CENTER: 
                case BOTTOM_LEFT: 
                case BOTTOM_RIGHT: {
                    this.viewscreenTopLeftY = this.rawCanvas.getHeight() - this.viewscreenHeight;
                    break;
                }
                default: {
                    this.viewscreenTopLeftY = (this.rawCanvas.getHeight() - this.viewscreenHeight) / 2.0;
                    break;
                }
            }
        } else {
            this.viewscreenHeight = this.rawCanvas.getHeight();
            this.viewscreenWidth = this.viewscreenHeight * viewportAspectRatio;
            this.viewscreenTopLeftY = 0.0;
            switch (this.positionMode) {
                case TOP_LEFT: 
                case BOTTOM_LEFT: 
                case CENTER_LEFT: {
                    this.viewscreenTopLeftX = 0.0;
                    break;
                }
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: 
                case CENTER_RIGHT: {
                    this.viewscreenTopLeftX = this.rawCanvas.getWidth() - this.viewscreenWidth;
                    break;
                }
                default: {
                    this.viewscreenTopLeftX = (this.rawCanvas.getWidth() - this.viewscreenWidth) / 2.0;
                }
            }
        }
    }

    void recomputeTransforms() {
        this.drawOnViewscreenTransform = this.defaultTransform();
        this.drawOnViewscreenTransform.setTx(this.viewscreenTopLeftX);
        this.drawOnViewscreenTransform.setTy(this.viewscreenTopLeftY);
        this.drawOnViewportTransform = this.defaultTransform();
        this.drawOnViewportTransform.append((Transform)this.drawOnViewscreenTransform);
        this.drawOnViewportTransform.setMxx(this.viewscreenWidth / this.viewportWidth);
        this.drawOnViewportTransform.setMyy(this.viewscreenHeight / this.viewportHeight);
        this.drawOnWorldTransform = this.defaultTransform();
        this.drawOnWorldTransform.append((Transform)this.drawOnViewportTransform);
        this.drawOnWorldTransform.setTx(this.drawOnWorldTransform.getTx() - this.viewportTopLeftX * this.drawOnWorldTransform.getMxx());
        this.drawOnWorldTransform.setTy(this.drawOnWorldTransform.getTy() - this.viewportTopLeftY * this.drawOnWorldTransform.getMyy());
    }

    private boolean sizesAreValid() {
        return this.rawCanvas.getWidth() > 0.0 && this.rawCanvas.getHeight() > 0.0 && this.worldWidth > 0.0 && this.worldHeight > 0.0 && this.viewscreenWidth > 0.0 && this.viewscreenHeight > 0.0 && this.viewportWidth > 0.0 && this.viewportHeight > 0.0;
    }

    public void drawOnCanvas(DrawingLambdaFx lambda) {
        this.rawGc.save();
        this.rawGc.beginPath();
        this.rawGc.rect(0.0, 0.0, this.rawCanvas.getWidth(), this.rawCanvas.getHeight());
        this.rawGc.clip();
        lambda.draw(this.rawGc);
        this.rawGc.restore();
    }

    public void drawOnViewscreen(DrawingLambdaFx lambda) {
        this.rawGc.save();
        this.rawGc.setTransform(this.drawOnViewscreenTransform);
        if (this.clipModes.contains((Object)ClipMode.CLIP_AT_VIEWSCREEN)) {
            this.rawGc.beginPath();
            this.rawGc.rect(0.0, 0.0, this.viewscreenWidth, this.viewscreenHeight);
            this.rawGc.clip();
        }
        lambda.draw(this.rawGc);
        this.rawGc.restore();
    }

    public void drawOnViewport(DrawingLambdaFx lambda) {
        this.rawGc.save();
        this.rawGc.setTransform(this.drawOnViewportTransform);
        if (this.clipModes.contains((Object)ClipMode.CLIP_AT_VIEWPORT)) {
            this.rawGc.beginPath();
            this.rawGc.rect(0.0, 0.0, this.viewportWidth, this.viewportHeight);
            this.rawGc.clip();
        }
        lambda.draw(this.rawGc);
        this.rawGc.restore();
    }

    public void drawOnWorld(DrawingLambdaFx lambda) {
        this.rawGc.save();
        this.rawGc.setTransform(this.drawOnWorldTransform);
        if (this.clipModes.contains((Object)ClipMode.CLIP_AT_VIEWPORT)) {
            this.rawGc.beginPath();
            this.rawGc.rect(this.viewportTopLeftX, this.viewportTopLeftY, this.viewportWidth, this.viewportHeight);
            this.rawGc.clip();
        }
        if (this.clipModes.contains((Object)ClipMode.CLIP_AT_WORLD)) {
            this.rawGc.beginPath();
            this.rawGc.rect(0.0, 0.0, this.worldWidth, this.worldHeight);
            this.rawGc.clip();
        }
        lambda.draw(this.rawGc);
        this.rawGc.restore();
    }

    public double worldWidthFromCanvasWidth(double canvasWidth) {
        return canvasWidth / this.drawOnWorldTransform.getMxx();
    }

    public double worldHeightFromCanvasHeight(double canvasHeight) {
        return canvasHeight / this.drawOnWorldTransform.getMyy();
    }

    public double canvasWidthFromWorldWidth(double worldWidth) {
        return worldWidth * this.drawOnWorldTransform.getMxx();
    }

    public double canvasHeightFromWorldHeight(double worldHeight) {
        return worldHeight * this.drawOnWorldTransform.getMyy();
    }

    public double worldXFromCanvasX(double canvasX) {
        return (canvasX - this.drawOnWorldTransform.getTx()) / this.drawOnWorldTransform.getMxx();
    }

    public double worldYFromCanvasY(double canvasY) {
        return (canvasY - this.drawOnWorldTransform.getTy()) / this.drawOnWorldTransform.getMyy();
    }

    public double viewportXFromCanvasX(double canvasX) {
        return (canvasX - this.drawOnViewportTransform.getTx()) / this.drawOnViewportTransform.getMxx();
    }

    public double viewportYFromCanvasY(double canvasY) {
        return (canvasY - this.drawOnViewportTransform.getTy()) / this.drawOnViewportTransform.getMyy();
    }

    public double viewscreenXFromCanvasX(double canvasX) {
        return (canvasX - this.drawOnViewscreenTransform.getTx()) / this.drawOnViewscreenTransform.getMxx();
    }

    public double viewscreenYFromCanvasY(double canvasY) {
        return (canvasY - this.drawOnViewscreenTransform.getTy()) / this.drawOnViewscreenTransform.getMyy();
    }

    public void relocateResizeViewport(double topLeftX, double topLeftY, double width, double height) {
        this.viewportTopLeftX = topLeftX;
        this.viewportTopLeftY = topLeftY;
        this.viewportWidth = width;
        this.viewportHeight = height;
        if (this.sizesAreValid()) {
            this.resizeRelocateRegions();
            this.recomputeTransforms();
        }
        this.invalidate();
    }

    public void relocateViewport(double topLeftX, double topLeftY) {
        this.viewportTopLeftX = topLeftX;
        this.viewportTopLeftY = topLeftY;
        if (this.sizesAreValid()) {
            this.resizeRelocateRegions();
            this.recomputeTransforms();
        }
        this.invalidate();
    }
}

