/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.app.frontend;

import ca.ntro.app.Ntro;
import ca.ntro.app.frontend.View;
import ca.ntro.app.frontend.ViewFx;
import ca.ntro.app.frontend.ViewLoader;
import ca.ntro.core.NtroCore;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;

public class ViewLoaderFx<V extends View<?>>
implements ViewLoader<V> {
    private String fxmlPath;
    private String cssPath;
    private String resourcesPath;
    private Class<? extends View<?>> viewClass;

    public Class<? extends View<?>> getViewClass() {
        return this.viewClass;
    }

    public void setViewClass(Class<? extends View<?>> viewClass) {
        this.viewClass = viewClass;
    }

    public String getFxmlPath() {
        return this.fxmlPath;
    }

    public void setFxmlPath(String fxmlPath) {
        this.fxmlPath = fxmlPath;
    }

    public String getCssPath() {
        return this.cssPath;
    }

    public void setCssPath(String cssPath) {
        this.cssPath = cssPath;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    public void setResourcesPath(String resourcesPath) {
        this.resourcesPath = resourcesPath;
    }

    private URL urlFromPath(String path) {
        URL url = null;
        if (Ntro.options().useJarResources()) {
            url = this.viewClass.getResource(path);
        } else {
            try {
                url = Paths.get(path, new String[0]).toUri().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (url == null) {
                throw new RuntimeException("Not found " + path);
            }
        }
        return url;
    }

    private String resourceNameFromPath(String path) {
        String resourceName = path.replace("/", ".");
        if (resourceName.startsWith(".")) {
            resourceName = resourceName.substring(1);
        }
        if (resourceName.endsWith(".properties")) {
            int index = resourceName.lastIndexOf(".properties");
            resourceName = resourceName.substring(0, index);
        }
        return resourceName;
    }

    private FXMLLoader createFxmlLoader() {
        FXMLLoader loader = null;
        URL fxmlUrl = this.urlFromPath(this.getFxmlPath());
        ResourceBundle resources = this.loadResourceBundle();
        loader = resources != null ? new FXMLLoader(fxmlUrl, resources) : new FXMLLoader(fxmlUrl);
        return loader;
    }

    public ResourceBundle loadResourceBundle() {
        ResourceBundle resources = null;
        if (this.getResourcesPath() != null) {
            try {
                resources = ResourceBundle.getBundle(this.resourceNameFromPath(this.getResourcesPath()));
                if (resources == null) {
                    throw new RuntimeException("Resources not found: " + this.getResourcesPath());
                }
            }
            catch (MissingResourceException e) {
                throw new RuntimeException("Resources not found: " + this.getResourcesPath());
            }
        }
        return resources;
    }

    @Override
    public V createView() {
        FXMLLoader loader = this.createFxmlLoader();
        Parent parent = null;
        try {
            parent = (Parent)loader.load();
        }
        catch (Exception e) {
            NtroCore.logger().fatal((Throwable)e);
        }
        if (this.getCssPath() != null) {
            URL cssUrl = this.urlFromPath(this.getCssPath());
            if (cssUrl == null) {
                throw new RuntimeException(".css file not found: " + this.getCssPath());
            }
            parent.getStylesheets().add((Object)cssUrl.toExternalForm());
        }
        View view = null;
        try {
            view = (View)loader.getController();
            if (this.viewClass != null && !this.viewClass.isInstance(view)) {
                NtroCore.logger().fatal("View class mismatch in " + this.fxmlPath + "\n\n\tFXML -> fx:controller = \"" + view.getClass().getName() + "\"\n\tJava -> registrar.registerView(" + NtroCoreImpl.reflection().simpleName(this.viewClass) + ".class, \"" + this.fxmlPath + "\");");
            }
        }
        catch (Exception e) {
            NtroCore.logger().fatal("Error with fx:controller", (Throwable)e);
        }
        if (view == null) {
            NtroCore.logger().fatal("Error with fx:controller (view == null)");
        }
        if (!(view instanceof ViewFx)) {
            NtroCore.logger().fatal("Error with fx:controller (view !instanceof ViewFx)");
        }
        ((ViewFx)view).setPane((Pane)parent);
        try {
            view.initialize();
        }
        catch (Exception e) {
            NtroCore.logger().fatal("Error loading " + this.fxmlPath + " (" + NtroCoreImpl.reflection().simpleName(view.getClass()) + ")\n", (Throwable)e);
        }
        return (V)view;
    }
}

