package depart.maquettes;

import ca.ntro.app.Ntro;
import ca.ntro.app.events.EventRegistrar;
import ca.ntro.app.frontend.FrontendFx;
import ca.ntro.app.frontend.ViewRegistrarFx;
import ca.ntro.app.session.SessionRegistrar;
import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.evenements.AfficherPartie;
import depart.frontal.evenements.FileAttenteVue;
import depart.frontal.evenements.vueFileAttente;
import depart.frontal.taches.CreerVues;
import depart.frontal.taches.GererFileAttente;
import depart.frontal.taches.Navigation;
import depart.frontal.taches.PremierAffichage;
import depart.frontal.vues.VuePartie;
import depart.frontal.vues.VueRacine;

public class FrontalPong implements FrontendFx {

	@Override
	public void registerEvents(EventRegistrar registrar) {

		registrar.registerEvent(vueFileAttente.class);
		registrar.registerEvent(AfficherPartie.class);
	}

	@Override
	public void registerViews(ViewRegistrarFx registrar) {

		registrar.registerDefaultLocale(Ntro.buildLocale("fr"));
		registrar.registerTranslations(Ntro.buildLocale("fr"), "/traductions/fr.properties");
		registrar.registerTranslations(Ntro.buildLocale("en"), "/traductions/en.properties");

		registrar.registerView(VueRacine.class, "/vues/racine.fxml");
		registrar.registerView(FileAttenteVue.class, "/vues/parametres.fxml");
		registrar.registerView(VuePartie.class, "/vues/partie.fxml");

		//registrar.registerStylesheet("/style/dev.css");
		registrar.registerStylesheet("/style/prod.css");
	}

	@Override
	public void registerSessionClass(SessionRegistrar registrar) {
		
	}

	@Override
	public void createTasks(FrontendTasks tasks) {

		CreerVues.creerTaches(tasks);
		PremierAffichage.creerTaches(tasks);
		Navigation.creerTaches(tasks);
		GererFileAttente.creerTaches(tasks);
	}

}
