package depart.frontal.taches;

import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.evenements.FileAttenteVue;
import depart.frontal.evenements.vueFileAttente;
import depart.frontal.vues.VueRacine;
import ca.ntro.app.Ntro;
import ca.ntro.app.services.Window;

import static ca.ntro.app.tasks.frontend.FrontendTasks.*;

public class PremierAffichage {
	
	public static void creerTaches(FrontendTasks tasks) {
		
		tasks.taskGroup("PremierAffichage")
		
		     .waitsFor("creerLesVues")
		
		     .contains(subTasks -> {

				installerVueRacine(subTasks);

				afficherFenetre(subTasks);

				naviguerVersFileAttente(subTasks);

		     });
	}

	private static void installerVueRacine(FrontendTasks subTasks) {

		subTasks.task("placerLaVueRacine")
		
		        .waitsFor(window())
		      
		        .waitsFor(created(VueRacine.class))

		        .executes(inputs -> {
		    	  
		    	  VueRacine vueRacine  = inputs.get(created(VueRacine.class));
		    	  Window    window     = inputs.get(window());

		    	  window.installRootView(vueRacine);
		      });
	}

	private static void afficherFenetre(FrontendTasks subTasks) {

		subTasks.task("afficherFenetre")

		        .waitsFor(window())

		        .executes(inputs -> {

		    	    Window window = inputs.get(window());

		    	    window.show();
		    	    
		        });
	}

	private static void naviguerVersFileAttente(FrontendTasks tasks) {

		tasks.task("naviguerVersFileAttente")

		     .waitsFor(created(FileAttenteVue.class))   // pour réagir modifs fichier file_attente.fxml

		     .executes(inputs -> {

		    	 Ntro.newEvent(vueFileAttente.class).trigger();

		     });
	}

}
