package depart.frontal.taches;

import static ca.ntro.app.tasks.frontend.FrontendTasks.*;

import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.evenements.AfficherPartie;
import depart.frontal.evenements.FileAttenteVue;
import depart.frontal.evenements.vueFileAttente;
import depart.frontal.vues.VuePartie;
import depart.frontal.vues.VueRacine;

public class Navigation {
    
    public static void creerTaches(FrontendTasks tasks) {

        tasks.taskGroup("Navigation")
        
             .waitsFor("PremierAffichage")
             
             .contains(subTasks -> {

                 afficherVueFileAttente(subTasks);

                 afficherVuePartie(subTasks);

             });
    }

    private static void afficherVueFileAttente(FrontendTasks tasks) {

        tasks.task("afficherVueFileAttente")

              .waitsFor(event(vueFileAttente.class))

              .waitsFor(created(VueRacine.class))

              .waitsFor(created(FileAttenteVue.class))

              .executes(inputs -> {
                  
                  vueFileAttente evtAfficherVueFileAttente = inputs.get(event(vueFileAttente.class));
                  VueRacine                 vueRacine                 = inputs.get(created(VueRacine.class));
                  FileAttenteVue            vueFileAttente            = inputs.get(created(FileAttenteVue.class));
                  
                  evtAfficherVueFileAttente.appliquerA(vueRacine, vueFileAttente);
              });
    }

    private static void afficherVuePartie(FrontendTasks subTasks) {

        subTasks.task("afficherVuePartie")
        
             .waitsFor(event(AfficherPartie.class))

             .waitsFor(created(VueRacine.class))

             .waitsFor(created(VuePartie.class))

             .executes(inputs -> {

                 AfficherPartie evtAfficherVuePartie = inputs.get(event(AfficherPartie.class));
                 VueRacine            vueRacine            = inputs.get(created(VueRacine.class));
                 VuePartie            vuePartie            = inputs.get(created(VuePartie.class));

                 evtAfficherVuePartie.methodeA(vueRacine, vuePartie);
             });
        
    }

}
