package depart.frontal.taches;


import static ca.ntro.app.tasks.frontend.FrontendTasks.*;

import ca.ntro.app.modified.Modified;
import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.commun.modeles.FileAttente;
import depart.frontal.evenements.FileAttenteVue;


public class GererFileAttente {
	
	public static void creerTaches(FrontendTasks tasks) {

		tasks.taskGroup("GererFileAttente")
		
		     .waitsFor("afficherVueFileAttente")

		     .contains(subTasks -> {
		    	 
		    	 observerFileAttente(subTasks);

		     });
	}

	private static void observerFileAttente(FrontendTasks tasks) {
		
		tasks.task("observerFileAttente")
		
			 .waitsFor(modified(FileAttente.class))
			 
			 .waitsFor(created(FileAttenteVue.class))

		     .executes(inputs -> {
		    	 
		    	 FileAttenteVue                        vueFileAttente = inputs.get(created(FileAttenteVue.class));
		    	 Modified<FileAttente> fileAttente    = inputs.get(modified(FileAttente.class));
		    	 
		    	 fileAttente.currentValue().afficherSur(vueFileAttente);

		     });
	}

}