package depart.frontal.taches;

import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.evenements.FileAttenteVue;
import depart.frontal.vues.VuePartie;
import depart.frontal.vues.VueRacine;

import static ca.ntro.app.tasks.frontend.FrontendTasks.*;

import ca.ntro.app.frontend.ViewLoader;

public class CreerVues {
	
	public static void creerTaches(FrontendTasks tasks) {
		
		tasks.taskGroup("creerLesVues")
		
		     .waitsFor(viewLoaders())
		
		     .contains(subTasks -> {
		    	 
				tacheA1(subTasks);
				creerVueRacine(subTasks);
				creerVuePartie(subTasks);

		     });
	}

	private static void tacheA1(FrontendTasks subTasks) {

		subTasks.task(create(FileAttenteVue.class))

		     .waitsFor(viewLoader(FileAttenteVue.class))

		     .executesAndReturnsValue(inputs -> {
		    	 
		    	 ViewLoader<FileAttenteVue> viewLoader = inputs.get(viewLoader(FileAttenteVue.class));
		    	 FileAttenteVue vueFileAttente = viewLoader.createView();

		    	 return vueFileAttente;
		     });
	}

	private static void creerVueRacine(FrontendTasks subTasks) {

		subTasks.task(create(VueRacine.class))

		     .waitsFor(viewLoader(VueRacine.class))

		     .executesAndReturnsValue(inputs -> {
		    	 
		    	 ViewLoader<VueRacine> viewLoader = inputs.get(viewLoader(VueRacine.class));
		    	 VueRacine vueRacine              = viewLoader.createView();

		    	 return vueRacine;
		     });
	}

	private static void creerVuePartie(FrontendTasks subTasks) {

		subTasks.task(create(VuePartie.class))

		     .waitsFor(viewLoader(VuePartie.class))

		     .executesAndReturnsValue(inputs -> {
		    	 
		    	 ViewLoader<VuePartie> viewLoader = inputs.get(viewLoader(VuePartie.class));
		    	 VuePartie vuePartie = viewLoader.createView();

		    	 return vuePartie;
		     });
	}

}
