package depart.frontal.evenements;

import ca.ntro.app.Ntro;
import ca.ntro.app.frontend.ViewFx;
import depart.commun.messages.AjouterPartieMsg;
import depart.maquettes.MaquettePartie;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;

public class FileAttenteVue extends ViewFx {

	@FXML
	private Label labelFileAttente;

	@FXML
	private Button boutonJouer;

	@FXML
	private Button boutonQuitter;

	@Override
	public void initialize() {
		Ntro.assertNotNull(labelFileAttente);
		Ntro.assertNotNull(boutonJouer);
		Ntro.assertNotNull(boutonQuitter);
		
		boutonJouer.setOnAction(evtFx -> {

			Ntro.newEvent(AfficherPartie.class).trigger();
		});
		
		boutonQuitter.setOnAction(evtFx -> {
			
			Ntro.newMessage(AjouterPartieMsg.class)
			    .setIdJoueurA(MaquettePartie.idJoueur())
			    .setNomJoueurA(MaquettePartie.nomJoueur())
			    .setScoreJoueurA(MaquettePartie.scoreAuHasard())
			    .setIdJoueurB(MaquettePartie.idJoueur())
			    .setNomJoueurB(MaquettePartie.nomJoueur())
			    .setScoreJoueurB(MaquettePartie.scoreAuHasard())
			    .send();
		});
	}

	public void afficherTexteFileAttente(String paramA) {
		labelFileAttente.setText(paramA);
	}

}
