package depart.dorsal.taches;

import static ca.ntro.app.tasks.backend.BackendTasks.*;

import ca.ntro.app.tasks.backend.BackendTasks;
import depart.commun.messages.AjouterPartieMsg;
import depart.commun.modeles.FileAttente;

public class ModifierFileAttente {
	
	public static void creerTaches(BackendTasks tasks) {

		tasks.taskGroup("ModifierFileAttente")

		     .waitsFor(model(FileAttente.class))
		
		     .contains(subTasks -> {
		    	  
		    	 ajouterPartie(subTasks);

		     });
	}

	private static void ajouterPartie(BackendTasks subTasks) {

		subTasks.task("ajouterPartie")

		     .waitsFor(model(FileAttente.class))

		     .waitsFor(message(AjouterPartieMsg.class))

		     .executes(inputs -> {

		    	 AjouterPartieMsg msgAjouterPartie   = inputs.get(message(AjouterPartieMsg.class));
		    	 FileAttente modeleFileAttente = inputs.get(model(FileAttente.class));

		    	 msgAjouterPartie.ajouterA(modeleFileAttente);

		     });
	}

}
