package depart.commun.valeurs;

import ca.ntro.app.models.ModelValue;

public class PartieEnFile implements ModelValue {

	private String idPartie;

    private String idJoueurA;
    private String nomJoueurA;
    private int    scoreJoueurA;

    private String idJoueurB;
    private String nomJoueurB;
    private int    scoreJoueurB;

	public PartieEnFile(String idPartie, 
		                String idJoueurA, 
						String nomJoueurA, 
						int scoreJoueurA, 
						String idJoueurB, 
						String nomJoueurB, 
						int scoreJoueurB) {
							
		this.idPartie = idPartie;
		this.idJoueurA = idJoueurA;
		this.nomJoueurA = nomJoueurA;
		this.scoreJoueurA = scoreJoueurA;
		this.idJoueurB = idJoueurB;
		this.nomJoueurB = nomJoueurB;
		this.scoreJoueurB = scoreJoueurB;
	}

	@Override
	public String toString() {

		StringBuilder builder = new StringBuilder();

		builder.append(nomJoueurA);
		builder.append(" Vs ");
		if(nomJoueurB == null){
			builder.append("???");
		}else{
			builder.append(nomJoueurB);
		}

		builder.append("  ");
		builder.append(scoreJoueurA);
		builder.append("-");
		builder.append(scoreJoueurB);

		return builder.toString();
	}

}
