package depart.commun.modeles;

import java.util.ArrayList;
import java.util.List;

import ca.ntro.app.models.Model;
import ca.ntro.app.models.WatchJson;
import ca.ntro.app.models.WriteObjectGraph;
import depart.commun.valeurs.PartieEnFile;
import depart.frontal.evenements.FileAttenteVue;

public class FileAttente implements Model, WatchJson, WriteObjectGraph {

	private int prochainId = 0;

	private List<PartieEnFile> parties = new ArrayList<>();

	public void afficherSur(FileAttenteVue vueA) {

		vueA.afficherTexteFileAttente(this.toString());
	}
	
	public String toString() {

		StringBuilder builder = new StringBuilder();

		builder.append("prochainId: " + prochainId);
		builder.append(System.lineSeparator());
		builder.append(System.lineSeparator());

		builder.append("valeurs: ");
		builder.append(System.lineSeparator());

		for(PartieEnFile partie : parties) {

			builder.append("  ");
			builder.append(partie.toString());
			builder.append(System.lineSeparator());
		}

		return builder.toString();
	}

	public void ajouterPartie(String idJoueurA, 
		                 	  String nomJoueurA, 
						      int scoreJoueurA, 
						      String idJoueurB, 
						      String nomJoueurB, 
						      int scoreJoueurB) {

		parties.add(new PartieEnFile(String.valueOf(prochainId++), 
									idJoueurA, 
									nomJoueurA, 
									scoreJoueurA, 
									idJoueurB, 
									nomJoueurB, 
									scoreJoueurB));
	}

}
