package depart.commun.messages;

import ca.ntro.app.messages.Message;
import depart.commun.modeles.FileAttente;

public class AjouterPartieMsg extends Message<AjouterPartieMsg> {

	private String idJoueurA;
    private String nomJoueurA;
    private int    scoreJoueurA;

    private String idJoueurB;
    private String nomJoueurB;
    private int    scoreJoueurB;

	public AjouterPartieMsg setIdJoueurA(String idJoueurA) {
		this.idJoueurA = idJoueurA;
		return this;
	}

	public AjouterPartieMsg setNomJoueurA(String nomJoueurA) {
		this.nomJoueurA = nomJoueurA;
		return this;
	}

	public AjouterPartieMsg setScoreJoueurA(int scoreJoueurA) {
		this.scoreJoueurA = scoreJoueurA;
		return this;
	}

	public AjouterPartieMsg setIdJoueurB(String idJoueurB) {
		this.idJoueurB = idJoueurB;
		return this;
	}

	public AjouterPartieMsg setNomJoueurB(String nomJoueurB) {
		this.nomJoueurB = nomJoueurB;
		return this;
	}

	public AjouterPartieMsg setScoreJoueurB(int scoreJoueurB) {
		this.scoreJoueurB = scoreJoueurB;
		return this;
	}

	public void ajouterA(FileAttente objA) {
		objA.ajouterPartie(idJoueurA, 
			          nomJoueurA,
			          scoreJoueurA,
					  idJoueurB,
					  nomJoueurB,
					  scoreJoueurB);
	}

}
