package depart;

import ca.ntro.app.NtroAppFx;
import ca.ntro.app.backend.BackendRegistrar;
import ca.ntro.app.frontend.FrontendRegistrarFx;
import ca.ntro.app.messages.MessageRegistrar;
import ca.ntro.app.models.ModelRegistrar;
import depart.commun.messages.AjouterPartieMsg;
import depart.commun.modeles.FileAttente;
import depart.commun.valeurs.PartieEnFile;
import depart.dorsal.DorsalPong;
import depart.maquettes.FrontalPong;

public class AppPong implements NtroAppFx {
	
	public static void main(String[] args) {

		NtroAppFx.launch(args);
	}

	@Override
	public void registerModels(ModelRegistrar registrar) {

		registrar.registerModel(FileAttente.class);
		registrar.registerValue(PartieEnFile.class);
	}

	@Override
	public void registerMessages(MessageRegistrar registrar) {

		registrar.registerMessage(AjouterPartieMsg.class);
	}

	@Override
	public void registerFrontend(FrontendRegistrarFx registrar) {

		registrar.registerFrontend(FrontalPong.class);
	}

	@Override
	public void registerBackend(BackendRegistrar registrar) {

		registrar.registerBackend(DorsalPong.class);
	}

}
