/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.structures;

import ca.ntro.core.stream.Stream;
import ca.ntro.core.stream.Visitor;
import ca.ntro.core.util.StringUtils;
import ca.ntro.ntro_app_fx_impl.structures.IdMapEntry;
import ca.ntro.ntro_core_impl.stream.StreamNtro;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IdMap<V> {
    private Map<String, V> valueById = new ConcurrentHashMap<String, V>();
    private V singletonValue = null;

    public Map<String, V> getValueById() {
        return this.valueById;
    }

    public void setValueById(Map<String, V> valueById) {
        this.valueById = valueById;
    }

    public synchronized void put(String id, V value) {
        if (this.isSingletonId(id)) {
            this.singletonValue = value;
        } else {
            this.valueById.put(id, value);
        }
    }

    private boolean isSingletonId(String id) {
        return StringUtils.isNullOrEmpty((String)id);
    }

    public synchronized V get(String id) {
        V value = null;
        value = this.isSingletonId(id) ? (V)this.singletonValue : (V)this.valueById.get(id);
        return value;
    }

    public Stream<V> values() {
        return this.entries().map(entry -> entry.value());
    }

    public Stream<IdMapEntry<V>> entries() {
        return new StreamNtro<IdMapEntry<V>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void forEach_(Visitor<IdMapEntry<V>> visitor) throws Throwable {
                IdMap idMap = IdMap.this;
                synchronized (idMap) {
                    if (IdMap.this.singletonValue != null) {
                        visitor.visit((Object)new IdMapEntry<V>(){

                            @Override
                            public String entryId() {
                                return null;
                            }

                            @Override
                            public V value() {
                                return IdMap.this.singletonValue;
                            }
                        });
                    }
                    for (final Map.Entry entry : IdMap.this.valueById.entrySet()) {
                        visitor.visit((Object)new IdMapEntry<V>(){

                            @Override
                            public String entryId() {
                                return (String)entry.getKey();
                            }

                            @Override
                            public V value() {
                                return entry.getValue();
                            }
                        });
                    }
                }
            }
        };
    }

    public String id(V value) {
        String id = null;
        if (this.singletonValue == value) {
            id = "";
        } else {
            for (Map.Entry<String, V> entry : this.valueById.entrySet()) {
                if (entry.getValue() != value) continue;
                id = entry.getKey();
                break;
            }
        }
        return id;
    }
}

