/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.services;

import ca.ntro.ntro_core_impl.services.TimeJdk;
import ca.ntro.ntro_core_impl.task_graphs.generic_task_graph.SimpleTaskOptions;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.ExecutableTask;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.ExecutableTaskNtro;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.SimpleTask;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.TaskContainer;
import ca.ntro.ntro_core_impl.task_graphs.task_graph_trace.TaskResultsEventHandler;
import ca.ntro.ntro_core_impl.task_graphs.task_graph_trace.TaskTraceNtro;
import java.util.Timer;
import java.util.TimerTask;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;

public abstract class TimeFx
extends TimeJdk {
    private SimpleTask tickHandler = null;

    public SimpleTask getTickHandler() {
        return this.tickHandler;
    }

    public void setTickHandler(SimpleTask tickHandler) {
        this.tickHandler = tickHandler;
    }

    public void runAfterDelay(long milliseconds, final Runnable runnable) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)runnable);
            }
        }, milliseconds);
    }

    public void runRepeatedly(long milliseconds, final Runnable runnable) {
        if (milliseconds <= 1L) {
            new AnimationTimer(){

                public void handle(long now) {
                    runnable.run();
                }
            }.start();
        } else {
            new Timer().scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater((Runnable)runnable);
                }
            }, 0L, milliseconds);
        }
    }

    public SimpleTask newTickHandlerTask(TaskContainer graph) {
        if (this.tickHandler == null) {
            this.tickHandler = (SimpleTask)graph.newTask("clock[nextTick]", (SimpleTaskOptions)SimpleTaskOptions.taskClass(ExecutableTaskNtro.class).traceClass(TaskTraceNtro.class).resultsClass(TaskResultsEventHandler.class));
            ((ExecutableTask)this.tickHandler.asExecutableTask()).onCancel((currentResults, notifyer) -> this.cancelTickHandler());
            this.startTickTimer();
        }
        return this.tickHandler;
    }

    protected abstract void startTickTimer();

    protected abstract void stopTickTimer();

    public void cancelTickHandler() {
        this.tickHandler = null;
        this.stopTickTimer();
    }
}

