/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.models;

import ca.ntro.app.models.Model;
import ca.ntro.core.stream.Stream;
import ca.ntro.ntro_app_fx_abstr.models.ModelSelectionsReader;
import ca.ntro.ntro_app_fx_abstr.models.ModelSelectionsStreamer;
import ca.ntro.ntro_app_fx_abstr.models.ModelSelectionsWriter;
import ca.ntro.ntro_app_fx_impl.models.SelectionsOneModel;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SelectionsByModel
implements ModelSelectionsWriter<SelectionsByModel>,
ModelSelectionsReader,
ModelSelectionsStreamer {
    private Map<String, SelectionsOneModel> selections = new HashMap<String, SelectionsOneModel>();

    @Override
    public SelectionsByModel setModelSelection(Class<? extends Model> modelClass, String modelId) {
        SelectionsOneModel modelSelections = this.getOrAddModelSelections(modelClass);
        modelSelections.setSelection(modelId);
        return this;
    }

    private SelectionsOneModel getOrAddModelSelections(Class<? extends Model> modelClass) {
        String modelClassName = NtroCoreImpl.reflection().simpleName(modelClass);
        SelectionsOneModel modelSelections = this.selections.get(modelClassName);
        if (modelSelections == null) {
            modelSelections = new SelectionsOneModel();
            this.selections.put(modelClassName, modelSelections);
        }
        return modelSelections;
    }

    @Override
    public SelectionsByModel addModelSelection(Class<? extends Model> modelClass, String modelId) {
        SelectionsOneModel modelSelections = this.getOrAddModelSelections(modelClass);
        modelSelections.addSelection(modelId);
        return this;
    }

    @Override
    public SelectionsByModel clearModelSelections(Class<? extends Model> modelClass) {
        SelectionsOneModel modelSelections = this.getOrAddModelSelections(modelClass);
        modelSelections.clearSelections();
        return this;
    }

    @Override
    public Stream<Class<? extends Model>> modelClasses() {
        Stream modelClassNames = Stream.forMapKeys(this.selections);
        Stream modelClasses = modelClassNames.map(className -> NtroCoreImpl.factory().namedClass(className));
        return modelClasses;
    }

    @Override
    public Stream<String> selections(Class<? extends Model> modelClass) {
        String modelClassName = NtroCoreImpl.reflection().simpleName(modelClass);
        SelectionsOneModel modelSelections = this.selections.get(modelClassName);
        if (modelSelections == null) {
            modelSelections = new SelectionsOneModel();
        }
        return modelSelections.selections();
    }

    public void restricTo(SelectionsByModel otherSelections) {
        Set<String> ourClasses = this.selections.keySet();
        Set<String> theirClasses = otherSelections.selections.keySet();
        ourClasses.retainAll(theirClasses);
        HashMap<String, SelectionsOneModel> newSelections = new HashMap<String, SelectionsOneModel>();
        for (String className : ourClasses) {
            SelectionsOneModel ourSelections = this.selections.get(className);
            SelectionsOneModel theirSelections = otherSelections.selections.get(className);
            ourSelections.restricTo(theirSelections);
            newSelections.put(className, ourSelections);
        }
        this.selections = newSelections;
    }

    @Override
    public boolean isModelSelected(Class<? extends Model> modelClass, String modelId) {
        boolean isSelected = false;
        String modelClassName = NtroCoreImpl.reflection().simpleName(modelClass);
        SelectionsOneModel modelSelections = this.selections.get(modelClassName);
        if (modelSelections != null) {
            isSelected = modelSelections.isModelSelected(modelId);
        }
        return isSelected;
    }

    @Override
    public boolean hasModelSelections(Class<? extends Model> modelClass) {
        String modelClassName = NtroCoreImpl.reflection().simpleName(modelClass);
        return this.selections.containsKey(modelClassName);
    }

    @Override
    public String getModelSelection(Class<? extends Model> modelClass) {
        return (String)this.selections(modelClass).findFirst(x -> true);
    }

    @Override
    public List<String> getModelSelections(Class<? extends Model> modelClass) {
        return this.selections(modelClass).collect();
    }
}

