/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.messages;

import ca.ntro.app.Ntro;
import ca.ntro.app.messages.Message;
import ca.ntro.app.messages.MessageAccessor;
import ca.ntro.app.modified.Modified;
import ca.ntro.app.modified.Snapshot;
import ca.ntro.app.services.MessageService;
import ca.ntro.app.session.Session;
import ca.ntro.core.NtroCore;
import ca.ntro.ntro_app_fx_abstr.messages.MessageAbstr;
import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_app_fx_impl.messages.DeliveryMode;
import ca.ntro.ntro_app_fx_impl.messages.MessageServer;
import ca.ntro.ntro_app_fx_impl.messages.SendMessageToImpl;
import ca.ntro.ntro_app_fx_impl.modified.Observable;
import ca.ntro.ntro_app_fx_impl.modified.Observation;
import ca.ntro.ntro_app_fx_impl.services.MessageServerNull;
import ca.ntro.ntro_app_fx_impl.structures.ValuesByClassId;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.SimpleTask;

public class MessageServiceImpl
implements MessageService {
    private ValuesByClassId<MessageAbstr, SimpleTask> messageHandlers = new ValuesByClassId();
    private ValuesByClassId<Observable, SimpleTask> observationHandlers = new ValuesByClassId();
    private ValuesByClassId<Observable, SimpleTask> snapshotHandlers = new ValuesByClassId();
    private MessageServer messageServer = new MessageServerNull();
    private DeliveryMode deliveryMode = DeliveryMode.LOCAL;

    @Override
    public <MSG extends Message> MSG newMessage(Class<MSG> messageClass) {
        Message message = (Message)NtroCore.factory().newInstance(messageClass);
        Object session = Ntro.session();
        ((Session)session).copyModelSelectionsInto(message);
        MessageAccessor.registerMessageService(message, this);
        return (MSG)message;
    }

    @Override
    public <MSG extends MessageAbstr> void addMessageHandler(Class<MSG> messageClass, SimpleTask messageHandlerTask) {
        this.messageHandlers.add(messageClass, null, messageHandlerTask);
    }

    @Override
    public <MSG extends MessageAbstr> void removeMessageHandler(Class<MSG> messageClass, SimpleTask messageHandlerTask) {
        this.messageHandlers.remove(messageClass, null, messageHandlerTask);
    }

    @Override
    public void addObserverTask(Class<? extends Observable> observableClass, SimpleTask observationHandlerTask) {
        this.observationHandlers.add(observableClass, null, observationHandlerTask);
        this.observe(observableClass, null);
    }

    @Override
    public void observe(Class<? extends Observable> observableClass, String observableId) {
        if (this.deliveryMode == DeliveryMode.LOCAL) {
            try {
                NtroImpl.models().watch(observableClass, observableId);
            }
            catch (ClassCastException e) {
                NtroCore.logger().fatal((Throwable)e);
            }
        } else {
            this.messageServer.requestFirstObservationFromServer(observableClass, observableId);
        }
    }

    @Override
    public void removeObserverTask(Class<? extends Observable> observableClass, SimpleTask observationHandlerTask) {
        this.observationHandlers.remove(observableClass, null, observationHandlerTask);
    }

    @Override
    public void addSnapshotTask(Class<? extends Observable> observableClass, SimpleTask observationHandlerTask) {
        this.snapshotHandlers.add(observableClass, null, observationHandlerTask);
        this.messageServer.requestFirstObservationFromServer(observableClass, null);
    }

    @Override
    public void removeSnapshotTask(Class<? extends Observable> observableClass, SimpleTask observationHandlerTask) {
        this.snapshotHandlers.remove(observableClass, null, observationHandlerTask);
    }

    @Override
    public void sendMessageToServer(MessageAbstr message) {
        this.messageServer.sendMessageToServer(message);
    }

    @Override
    public void broadcastMessageToOtherClients(MessageAbstr message) {
        switch (this.deliveryMode) {
            default: {
                this.deliverMessageLocally((Message)message);
                break;
            }
            case CLIENT_MODE: 
            case SERVER_MODE: {
                this.messageServer.broadcastMessageToOtherClients(message);
            }
        }
    }

    @Override
    public synchronized void receiveMessageFromServer(MessageAbstr message) {
        this.messageHandlers.values(message.getClass(), null).forEach(handler -> this.addMessageToMessageHandlerTask((SimpleTask)handler, message));
    }

    protected void addMessageToMessageHandlerTask(SimpleTask handler, MessageAbstr message) {
        handler.addResult((Object)message);
    }

    @Override
    public <O extends Observable> void receiveObservationFromServer(Class<O> observableClass, Observation<?> observation) {
        this.receiveObservationFromServer(observableClass, null, observation);
    }

    @Override
    public <O extends Observable> void receiveObservationFromServer(Class<O> observableClass, String observableId, Observation<?> observation) {
        Observation copyOfObservation = observation;
        if (this.messageServer.areMessagesLocal()) {
            copyOfObservation = (Observation)NtroCore.reflection().clone(observation);
        }
        this.observationHandlers.values(observableClass, null).forEach(handler -> {
            Object session = NtroImpl.session();
            if (((Session)session).isModelSelected(observableClass, observableId)) {
                this.addObservationToObservationHandlerTask((SimpleTask)handler, observation);
            } else if (observableId == null && !((Session)session).hasModelSelections(observableClass)) {
                this.addObservationToObservationHandlerTask((SimpleTask)handler, observation);
            }
        });
        this.snapshotHandlers.values(observableClass, observableId).forEach(handler -> this.addSnapshotToSnapshotHandlerTask((SimpleTask)handler, observation));
        this.snapshotHandlers.clear(observableClass, observableId);
    }

    protected void addObservationToObservationHandlerTask(SimpleTask handler, Observation<?> observation) {
        handler.addResult((Object)((Modified)observation));
    }

    protected void addSnapshotToSnapshotHandlerTask(SimpleTask handler, Snapshot<?> snapshot) {
        handler.addResult(snapshot);
    }

    @Override
    public <O extends Observable> void pushObservationToClients(Class<O> observableClass, String observationId, Observation<O> observation) {
        this.messageServer.pushObservationToClients(observableClass, observationId, observation);
    }

    @Override
    public <O extends Observable> void pushObservationToClients(Class<O> observationClass, Observation<O> observation) {
        this.pushObservationToClients(observationClass, null, observation);
    }

    public void deliverMessage(Message message) {
        switch (this.deliveryMode) {
            default: {
                this.deliverMessageLocally(message);
                break;
            }
            case CLIENT_MODE: {
                this.sendMessageToServer(message);
            }
        }
    }

    public void deliverMessageTo(Message<?> message, String sessionId) {
        switch (this.deliveryMode) {
            case LOCAL: {
                if (!((Session)Ntro.session()).sessionId().equals(sessionId)) break;
                this.deliverMessageLocally(message);
                break;
            }
            default: {
                this.deliverMessageLocally(message);
                break;
            }
            case CLIENT_MODE: {
                SendMessageToImpl sendMessageTo = new SendMessageToImpl(message, sessionId);
                this.sendMessageToServer(sendMessageTo);
            }
        }
    }

    private void deliverMessageLocally(Message message) {
        Message copyOfMessage = (Message)NtroCoreImpl.reflection().clone((Object)message);
        this.receiveMessageFromServer(copyOfMessage);
    }

    @Override
    public void registerMessageServer(MessageServer messageServer, DeliveryMode deliveryMode) {
        this.messageServer = messageServer;
        this.deliveryMode = deliveryMode;
        this.messageServer.onMessageFromServer(message -> this.receiveMessageFromServer(message));
        this.messageServer.onObservationFromServer((observableClass, observableId, observation) -> this.receiveObservationFromServer(observableClass, observableId, observation));
    }
}

