/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.frontend.window;

import ca.ntro.app.frontend.View;
import ca.ntro.app.services.Window;
import ca.ntro.core.NtroCore;
import ca.ntro.ntro_app_fx_impl.frontend.window.AppView;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class WindowFx
implements Window {
    private Stage primaryStage;
    private AppView appView = new AppView();
    private Scene rootScene;
    private double actualWidth = 1600.0;
    private double actualHeight = 900.0;
    private double SIZE_EPSILON = 2.0;
    private double fontSize = 13.0;
    private Runnable fontSizeListener = null;
    private Runnable onShow = () -> {};

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public WindowFx(Stage primaryStage) {
        this.primaryStage = primaryStage;
        this.rootScene = new Scene((Parent)this.appView, this.actualWidth, this.actualHeight);
        this.rootScene.setFill((Paint)Color.TRANSPARENT);
        primaryStage.setScene(this.rootScene);
        primaryStage.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                WindowFx.this.actualWidth = newValue.doubleValue();
            }
        });
        primaryStage.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                WindowFx.this.actualHeight = newValue.doubleValue();
            }
        });
    }

    @Override
    public void resize(double width, double height) {
        if (Math.abs(this.primaryStage.getWidth() - width) > this.SIZE_EPSILON) {
            this.primaryStage.setWidth(width);
        }
        if (Math.abs(this.primaryStage.getHeight() - height) > this.SIZE_EPSILON) {
            this.primaryStage.setHeight(height);
        }
        if (!this.primaryStage.isShowing()) {
            this.onShow = () -> {
                this.primaryStage.setWidth(width);
                this.primaryStage.setHeight(height);
            };
        }
    }

    @Override
    public void installRootView(View<?> rootView) {
        if (rootView.rootNode() == null) {
            NtroCore.logger().fatal("[WindowFx.installRootView] rootView.rootNode() is null");
        }
        this.actualWidth = this.primaryStage.getWidth();
        this.actualHeight = this.primaryStage.getHeight();
        this.setFontSizeImpl(this.fontSize);
        this.appView.installRootView(rootView);
        this.resize(this.actualWidth, this.actualHeight);
    }

    @Override
    public void show() {
        if (!this.primaryStage.isShowing()) {
            this.primaryStage.setIconified(false);
            this.onShow.run();
            this.primaryStage.show();
        }
    }

    @Override
    public void fullscreen(boolean isFullscreen) {
        this.primaryStage.setFullScreen(isFullscreen);
    }

    @Override
    public void decorations(boolean hasDecorations) {
        if (this.primaryStage.isShowing()) {
            NtroCore.logger().warning("[WARNING] window.decorations() must be called before window.show()");
            return;
        }
        if (hasDecorations) {
            this.primaryStage.initStyle(StageStyle.DECORATED);
        } else {
            this.primaryStage.initStyle(StageStyle.UNDECORATED);
        }
    }

    @Override
    public void hide() {
        WindowFx windowFx = this;
        ObservableList windows = windowFx.primaryStage.getWindows();
        javafx.stage.Window fxWindow = (javafx.stage.Window)windows.get(0);
        fxWindow.hide();
    }

    @Override
    public void displayFatalErrorMessage(String message) {
        this.appView.displayFatalErrorMessage(message);
    }

    @Override
    public void setTitle(String title) {
        this.primaryStage.setTitle(title);
    }

    @Override
    public void setFontSize(int size) {
        this.setFontSizeImpl(size);
        if (this.fontSizeListener != null) {
            this.fontSizeListener.run();
        }
    }

    public void setFontSizeImpl(double size) {
        this.appView.setStyle("-fx-font-size: " + size);
    }

    @Override
    public void multiplyFontSizeBy(double factor) {
        this.fontSize *= factor;
        this.setFontSizeImpl(this.fontSize);
        if (this.fontSizeListener != null) {
            this.fontSizeListener.run();
        }
    }

    public void onFontSizeChanged(Runnable listener) {
        this.fontSizeListener = listener;
    }

    @Override
    public void maximized(boolean isMaximized) {
        this.primaryStage.setMaximized(isMaximized);
    }
}

