/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.frontend.window;

import ca.ntro.app.frontend.View;
import ca.ntro.app.frontend.ViewFx;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class FadeOutRootViewContainer
extends ViewFx {
    private static final double FADE_DURATION = 200.0;
    private StackPane stackPane = new StackPane();
    private boolean useTransition = false;

    public FadeOutRootViewContainer(boolean useTransition) {
        this.useTransition = useTransition;
        this.initialize();
    }

    public FadeOutRootViewContainer() {
        this.initialize();
    }

    public void initialize() {
        this.stackPane.setBackground(Background.EMPTY);
        this.stackPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
    }

    @Override
    public Pane rootNode() {
        return this.stackPane;
    }

    public void installRootView(View<?> rootView) {
        Pane newRootView = (Pane)rootView.rootNode();
        if (this.useTransition) {
            this.installRootViewWithFade(newRootView);
        } else {
            this.installRootViewWithoutFade(newRootView);
        }
    }

    private void installRootViewWithoutFade(Pane newRootView) {
        this.stackPane.getChildren().clear();
        this.stackPane.getChildren().add((Object)newRootView);
        this.stackPane.setBackground(newRootView.getBackground());
    }

    private void installRootViewWithFade(Pane newRootView) {
        if (this.stackPane.getChildren().isEmpty()) {
            this.stackPane.getChildren().add((Object)newRootView);
            this.stackPane.setBackground(newRootView.getBackground());
        } else {
            Pane oldRootView = (Pane)this.stackPane.getChildren().get(0);
            this.stackPane.getChildren().add((Object)newRootView);
            this.stackPane.setBackground(newRootView.getBackground());
            oldRootView.toFront();
            newRootView.toBack();
            Timeline fadeOut = new Timeline();
            fadeOut.getKeyFrames().add((Object)new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)oldRootView.opacityProperty(), (Object)1.0)}));
            fadeOut.getKeyFrames().add((Object)new KeyFrame(new Duration(200.0), new KeyValue[]{new KeyValue((WritableValue)oldRootView.opacityProperty(), (Object)0.0, Interpolator.EASE_BOTH)}));
            fadeOut.setOnFinished(onFadeOutFinished -> this.stackPane.getChildren().remove((Object)oldRootView));
            fadeOut.playFromStart();
        }
    }

    public void clear() {
        this.stackPane = new StackPane();
    }
}

