/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.executable_spec;

import ca.ntro.app.Ntro;
import ca.ntro.app.backend.RemoteBackendNtro;
import ca.ntro.app.events.Event;
import ca.ntro.app.events.EventRegistrar;
import ca.ntro.app.frontend.Frontend;
import ca.ntro.app.frontend.View;
import ca.ntro.app.frontend.ViewData;
import ca.ntro.app.services.Window;
import ca.ntro.app.session.AfterSessionFirstCreated;
import ca.ntro.app.session.Session;
import ca.ntro.app.session.SessionAccessor;
import ca.ntro.app.session.SessionRegistrar;
import ca.ntro.app.tasks.frontend.FrontendTasks;
import ca.ntro.core.NtroCore;
import ca.ntro.core.locale.Locale;
import ca.ntro.core.services.JsonParseError;
import ca.ntro.core.tasks.Task;
import ca.ntro.ntro_app_fx_abstr.NtroClient;
import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_app_fx_impl.backend.Backend;
import ca.ntro.ntro_app_fx_impl.executable_spec.ExecutableSpec;
import ca.ntro.ntro_app_fx_impl.executable_spec.FrontendTasksSpec;
import ca.ntro.ntro_app_fx_impl.executable_spec.ViewSpec;
import ca.ntro.ntro_app_fx_impl.frontend.ViewRegistrar;
import ca.ntro.ntro_app_fx_impl.tasks.frontend.FrontendTaskFactory;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.json.JsonObject;
import ca.ntro.ntro_core_impl.task_graphs.generic_task_graph.SimpleTaskOptions;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.ExecutableTaskNtro;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.SimpleTask;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.SimpleTaskNtro;
import ca.ntro.ntro_core_impl.task_graphs.task_graph_trace.TaskResultsCondition;
import ca.ntro.ntro_core_impl.task_graphs.task_graph_trace.TaskResultsEventHandler;
import ca.ntro.ntro_core_impl.task_graphs.task_graph_trace.TaskTraceNtro;
import ca.ntro.ntro_core_impl.tasks.TaskWrapper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class ClientSpec<APP extends NtroClient>
extends ExecutableSpec<APP>
implements EventRegistrar,
SessionRegistrar,
ViewRegistrar {
    private String sessionId = null;
    private transient Window window = null;
    private String frontend = null;
    private transient Class<? extends Frontend> frontendClass = null;
    private transient Frontend<?> frontendObject = null;
    private FrontendTasksSpec frontendTasks = new FrontendTasksSpec();
    private transient FrontendTaskFactory frontendTaskFactory = new FrontendTaskFactory();
    private Map<String, String> events = new HashMap<String, String>();
    private transient Map<String, Class<?>> eventClasses = new HashMap();
    private String session = null;
    private transient Class<? extends Session> sessionClass = Session.class;
    private transient Session sessionObject = null;
    private String defaultLanguage = null;
    private String defaultCountry = null;
    private Map<String, String> translations = new HashMap<String, String>();
    private transient Map<String, Class<? extends View>> viewClasses = new HashMap<String, Class<? extends View>>();
    private Map<String, ViewSpec> views = new HashMap<String, ViewSpec>();
    private Map<String, String> viewData = new HashMap<String, String>();
    private transient Map<String, Class<?>> viewDataClasses = new HashMap();

    protected Locale getDefaultLocale() {
        return Ntro.locale().buildLocale(this.defaultLanguage, this.defaultCountry);
    }

    protected Class<? extends View> getViewClass(String viewClassName) {
        return this.viewClasses.get(viewClassName);
    }

    protected void forEachView(Consumer<ViewSpec> c) {
        for (ViewSpec view : this.views.values()) {
            c.accept(view);
        }
    }

    protected void forEachTranslation(BiConsumer<String, String> c) {
        for (Map.Entry<String, String> entry : this.translations.entrySet()) {
            c.accept(entry.getKey(), entry.getValue());
        }
    }

    protected void registerFrontendImpl(Class<? extends Frontend> frontendClass) {
        this.frontendClass = frontendClass;
        this.frontend = frontendClass.getCanonicalName();
    }

    protected void createFrontendAndCallItToFillSpec() {
        Ntro.logger().info("frontendClass: " + String.valueOf(this.frontendClass));
        if (this.frontendClass != null) {
            this.frontendObject = (Frontend)NtroCore.factory().newInstance(this.frontendClass);
            this.additionnalFrontendInitialization(this.frontendObject);
            this.frontendObject.registerSessionClass(this);
            this.frontendObject.registerEvents(this);
            this.frontendObject.createTasks(this.frontendTasks);
            this.registerViews(this.frontendObject);
        }
        if (this.defaultLanguage == null) {
            this.defaultLanguage = Ntro.locale().currentLocale().language();
        }
        if (this.defaultCountry == null) {
            this.defaultCountry = Ntro.locale().currentLocale().country();
        }
    }

    protected abstract void additionnalFrontendInitialization(Frontend var1);

    public void registerWindow(Window window) {
        this.window = window;
    }

    public void registerSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    protected abstract void registerViews(Frontend<?> var1);

    public boolean isFrontendRegistered() {
        return this.frontendObject != null;
    }

    public void prepareToFrontendExecuteTasks() {
        this.frontendTaskFactory.prepareToExecuteTasks();
        this.frontendTaskFactory.registerTaskTrace();
    }

    public void executeFrontendTasks() {
        this.frontendTaskFactory.executeTasks();
    }

    public void writeFrontendGraph() {
        if (this.frontendTaskFactory != null) {
            this.frontendTaskFactory.writeGraph();
        }
    }

    @Override
    public <E extends Event> void registerEvent(Class<E> eventClass) {
        this.registerClass(this.events, this.eventClasses, eventClass, "Event");
    }

    @Override
    public <S extends Session<?>> void registerSessionClass(Class<S> sessionClass) {
        this.sessionClass = sessionClass;
        this.session = sessionClass.getCanonicalName();
    }

    @Override
    public void createExecutableFromSpec() {
        super.createExecutableFromSpec();
        this.registerNamedClasses();
        this.createRegisteredSession(this.sessionId);
        this.createTasks();
    }

    private void createTasks() {
        this.addWindowTask();
        this.addViewLoaderTasks(this.frontendTaskFactory);
        this.addEventHandlerTasks();
        this.addSessionTask();
        this.frontendTasks.createSubTasks(this.frontendTaskFactory);
    }

    private void registerNamedClasses() {
        this.registerNamedClasses(this.events, this.eventClasses);
        for (Class<?> viewDataClass : this.viewDataClasses.values()) {
            NtroCore.factory().registerNamedClass(viewDataClass);
        }
        NtroCore.factory().registerNamedClass(this.sessionClass);
        this.forEachView(viewSpec -> viewSpec.registerNamedClass());
    }

    private void addEventHandlerTasks() {
        for (String eventName : this.events.keySet()) {
            Class<?> eventClass = this.eventClasses.get(eventName);
            Task eventHandlerTask = this.frontendTaskFactory.orphanTask(FrontendTasks.event(eventClass), (SimpleTaskOptions)SimpleTaskOptions.taskClass(SimpleTaskNtro.class).traceClass(TaskTraceNtro.class).resultsClass(TaskResultsEventHandler.class)).getTask();
            TaskWrapper eventHandlerTaskWrapper = (TaskWrapper)eventHandlerTask;
            SimpleTask eventHandler = (SimpleTask)eventHandlerTaskWrapper.getTaskImpl();
            NtroImpl.eventService().registerEventHandler(eventClass, eventHandler);
        }
    }

    protected abstract void addViewLoaderTasks(FrontendTaskFactory var1);

    private void addWindowTask() {
        this.frontendTaskFactory.orphanTask(FrontendTasks.window(), (SimpleTaskOptions)SimpleTaskOptions.taskClass(ExecutableTaskNtro.class).traceClass(TaskTraceNtro.class).resultsClass(TaskResultsCondition.class)).executesAndReturnsValue(inputs -> this.window);
    }

    public <S extends Session<?>> void createRegisteredSession(String sessionId) {
        Object session;
        if (this.sessionClass != null) {
            this.sessionObject = this.loadOrCreateSession(this.sessionClass, sessionId);
            NtroImpl.registerSession(this.sessionObject);
        }
        if (SessionAccessor.isNamedSession(session = Ntro.session())) {
            NtroCore.logger().info("session: " + ((Session)session).sessionId());
        } else {
            NtroCore.logger().info("anonymous session (" + ((Session)session).sessionId() + ")");
        }
    }

    private <S extends Session<?>> S loadOrCreateSession(Class<S> sessionClass, String sessionId) {
        S session = null;
        if (sessionId != null) {
            session = this.loadSessionFromFileIfPossible(sessionClass, sessionId);
        }
        if (session == null) {
            session = this.newSession(sessionClass, sessionId);
        }
        return session;
    }

    private <S extends Session<?>> S newSession(Class<S> sessionClass, String sessionId) {
        Session session = (Session)NtroCoreImpl.factory().newInstance(sessionClass);
        if (sessionId != null) {
            SessionAccessor.registerSessionId(session, sessionId);
        }
        if (session instanceof AfterSessionFirstCreated) {
            ((AfterSessionFirstCreated)((Object)session)).afterSessionFirstCreated();
        }
        return (S)session;
    }

    private <S extends Session<?>> S loadSessionFromFileIfPossible(Class<S> sessionClass, String sessionId) {
        String sessionsPath = Ntro.options().coreOptions().sessionsPath();
        Path sessionFilepath = Paths.get(sessionsPath, sessionId + ".json");
        String rawSessionFilepath = sessionFilepath.toAbsolutePath().toString();
        Session session = null;
        if (NtroCore.storage().ifFileExists(rawSessionFilepath)) {
            String sessionText = NtroCore.storage().readTextFile(rawSessionFilepath);
            try {
                JsonObject sessionJson = NtroCore.json().fromJsonString(sessionText);
                session = (Session)NtroCore.reflection().fromJsonObject(sessionJson);
                SessionAccessor.registerSessionId(session, sessionId);
            }
            catch (JsonParseError e) {
                NtroCoreImpl.logger().warning("JsonParseError for " + rawSessionFilepath);
            }
        }
        return (S)session;
    }

    public void addSessionTask() {
        Class<? extends Session> sessionClass = this.sessionClass;
        if (sessionClass == null) {
            sessionClass = Session.class;
        }
        this.frontendTaskFactory.orphanTask(FrontendTasks.session(sessionClass), (SimpleTaskOptions)SimpleTaskOptions.taskClass(ExecutableTaskNtro.class).traceClass(TaskTraceNtro.class).resultsClass(TaskResultsCondition.class)).executesAndReturnsValue(inputs -> this.sessionObject);
    }

    @Override
    public void runExecutable() {
        super.runExecutable();
        SessionAccessor.reObserveModelSelections(Ntro.session());
        if (this.isFrontendRegistered()) {
            this.prepareToFrontendExecuteTasks();
            this.executeFrontendTasks();
        } else {
            NtroCore.logger().fatal("Please register a frontend.");
        }
    }

    @Override
    public void registerDefaultLocale(Locale locale) {
        this.defaultLanguage = locale.language();
        this.defaultCountry = locale.country();
    }

    @Override
    public void registerTranslations(Locale locale, String resourcesPath) {
        this.translations.put(locale.language(), resourcesPath);
    }

    @Override
    public void registerViewData(Class<? extends ViewData> viewDataClass) {
        String viewDataName = viewDataClass.getSimpleName();
        String viewDataFullname = viewDataClass.getCanonicalName();
        this.viewData.put(viewDataName, viewDataFullname);
        this.viewDataClasses.put(viewDataName, viewDataClass);
    }

    protected void addViewSpec(String viewName, ViewSpec viewSpec) {
        this.views.put(viewName, viewSpec);
    }

    @Override
    protected void analyzeProjectClass(Class<?> _class) {
        super.analyzeProjectClass(_class);
        if (NtroCore.reflection().ifClassIsSubTypeOf(_class, Frontend.class)) {
            this.registerFrontendImpl(_class);
        } else if (NtroCore.reflection().ifClassIsSubTypeOf(_class, Event.class)) {
            this.registerEvent(_class);
        } else if (NtroCore.reflection().ifClassIsSubTypeOf(_class, Session.class)) {
            this.registerSessionClass(_class);
        } else if (NtroCore.reflection().ifClassIsSubTypeOf(_class, ViewData.class)) {
            this.registerViewData(_class);
        } else if (NtroCore.reflection().ifClassIsSubTypeOf(_class, View.class)) {
            this.viewClasses.put(_class.getCanonicalName(), _class);
        }
    }

    @Override
    protected void callExectuableCodeAndFillSpec(APP app) {
        this.callRegisterFrontend(app);
        this.createFrontendAndCallItToFillSpec();
        super.callExectuableCodeAndFillSpec(app);
    }

    protected abstract void callRegisterFrontend(APP var1);

    @Override
    protected Class<? extends Backend> desiredBackendClass() {
        return RemoteBackendNtro.class;
    }
}

