/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl;

import ca.ntro.app.options.SetOptionsLambda;
import ca.ntro.core.NtroCore;
import ca.ntro.ntro_app_fx_abstr.NtroExecutable;
import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_app_fx_impl.executable_spec.ExecutableSpec;
import ca.ntro.ntro_app_fx_impl.options.OptionsImpl;
import ca.ntro.ntro_core_impl.InitializerFinalizerImpl;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.options.CoreOptionsImpl;
import ca.ntro.ntro_core_impl.values.CodeLocation;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public abstract class NtroExecutableImpl<APP_CLASS extends NtroExecutable, PROJECT_DESC extends ExecutableSpec> {
    private static InitializerFinalizerImpl initializerFinalizer = null;
    protected ExecutableSpec projectDescription = this.createEmptySpec();
    protected OptionsImpl options = new OptionsImpl();
    private boolean initialized = false;
    private boolean launched = false;

    public static void registerInitializerFinalizer(Class<? extends InitializerFinalizerImpl> initializerFinalizerClass) {
        if (initializerFinalizer == null) {
            initializerFinalizer = (InitializerFinalizerImpl)NtroCore.factory().newInstance(initializerFinalizerClass);
        }
    }

    protected abstract ExecutableSpec createEmptySpec();

    protected PROJECT_DESC projectDescription() {
        return (PROJECT_DESC)this.projectDescription;
    }

    private void initialize() {
        this.registerOptions();
        this.deleteTmpFiles();
        initializerFinalizer.initialize();
        this.initializeNtroMode();
    }

    private void deleteTmpFiles() {
        File tmpDir = Paths.get(this.options.coreOptions().tmpPath(), new String[0]).toFile();
        if (tmpDir.exists()) {
            this.deleteTmpFiles(tmpDir);
        }
    }

    private void deleteTmpFiles(File tmpDir) {
        for (File tmpFile : tmpDir.listFiles()) {
            tmpFile.delete();
        }
    }

    public void registerOptions() {
        NtroImpl.registerOptions(this.options);
        NtroCoreImpl.registerOptions((CoreOptionsImpl)((CoreOptionsImpl)this.options.coreOptions()));
        NtroCore.logger().setErrorDialogEnabled(this.options.getErrorDialog());
    }

    public void setOptions(SetOptionsLambda lambda) {
        this.initializeIfNeeded();
        this.failIfAlreadyLaunched("setOptions");
        lambda.setOptions(this.options);
    }

    protected void failIfAlreadyLaunched(String methodName) {
        if (this.launched) {
            NtroCore.logger().fatal("Method " + methodName + " must be called before launch");
        }
    }

    public void initializeIfNeeded() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    public void loadOptions(String filePath) {
        this.initializeIfNeeded();
        this.failIfAlreadyLaunched("loadOptions");
    }

    public void launch(Class<? extends APP_CLASS> appClass) {
        this.launched = true;
        this.setDefaultExceptionHandler();
        this.createDirectoriesIfNeeded();
        this.launchImpl(appClass, this.projectDescription());
    }

    private void createDirectoriesIfNeeded() {
        File optionsDir;
        File graphsDir;
        File sessionsDir;
        File tmpDir;
        File storageDir = Paths.get(this.options.coreOptions().storagePath(), new String[0]).toFile();
        if (!storageDir.exists()) {
            storageDir.mkdirs();
        }
        if (!(tmpDir = Paths.get(this.options.coreOptions().tmpPath(), new String[0]).toFile()).exists()) {
            tmpDir.mkdirs();
        }
        if (!(sessionsDir = Paths.get(this.options.coreOptions().sessionsPath(), new String[0]).toFile()).exists()) {
            sessionsDir.mkdirs();
        }
        if (!(graphsDir = Paths.get(this.options.coreOptions().graphsPath(), new String[0]).toFile()).exists()) {
            graphsDir.mkdirs();
        }
        if (!(optionsDir = Paths.get(this.options.coreOptions().optionsPath(), new String[0]).toFile()).exists()) {
            optionsDir.mkdirs();
        }
    }

    private void setDefaultExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> NtroCoreImpl.logger().fatal(throwable));
    }

    protected abstract void launchImpl(Class<? extends APP_CLASS> var1, PROJECT_DESC var2);

    public void initializeWithArgs(String[] args) {
        this.initializeIfNeeded();
        Map<String, String> params = this.parseArgs(args);
        this.initializeWithParams(params);
    }

    private Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String arg : args) {
            String[] segments = arg.split("=");
            if (segments.length != 2) continue;
            String paramName = segments[0];
            String paramValue = segments[1];
            params.put(paramName, paramValue);
        }
        return params;
    }

    protected abstract void initializeWithParams(Map<String, String> var1);

    protected abstract void initializeNtroMode();

    public void resolveProjectPathIfNeeded(CodeLocation appLocation) {
        Class appClass = appLocation._class();
        String appFilename = appClass.getSimpleName() + ".java";
        String projectDirname = appClass.getPackage().getName();
        String thisVmClasspath = System.getProperty("java.class.path");
        this.options.resolveProjectPathIfNeeded(appFilename, projectDirname);
    }
}

