/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.app.world2d;

import ca.ntro.app.fx.controls.ResizableWorld2dCanvasFx;
import ca.ntro.app.fx.controls.World2dMouseEventFx;
import ca.ntro.app.models.ModelValue;
import ca.ntro.app.world2d.Object2dFx;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.AnonymousRegion2dNtro;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class World2dFx
implements ModelValue {
    public static final double DEFAULT_WIDTH = 640.0;
    public static final double DEFAULT_HEIGHT = 360.0;
    private final double INTERSECT_EPSILON = 5.0;
    private double width = 640.0;
    private double height = 360.0;
    private List<Object2dFx> objects = new ArrayList<Object2dFx>();
    private List<String> idsOfObjectsToRemove = new ArrayList<String>();
    private List<Object2dFx> objectsToAdd = new ArrayList<Object2dFx>();
    private boolean clipAtViewport = true;

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public List<Object2dFx> getObjects() {
        return this.objects;
    }

    public void setObjects(List<Object2dFx> objects) {
        this.objects = objects;
    }

    public boolean getClipAtViewport() {
        return this.clipAtViewport;
    }

    public void setClipAtViewport(boolean clipAtViewport) {
        this.clipAtViewport = clipAtViewport;
    }

    protected abstract void initialize();

    protected abstract void onMouseEventNotConsumed(World2dMouseEventFx var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFx() {
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            for (Object2dFx object2d : this.objects) {
                object2d.initializeFx();
            }
        }
    }

    public void addObject2d(Object2dFx object2d) {
        object2d.setWorld2d(this);
        object2d.initialize();
        this.objectsToAdd.add(object2d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOn(ResizableWorld2dCanvasFx canvas) {
        this.updateObjects();
        AnonymousRegion2dNtro viewport = new AnonymousRegion2dNtro(canvas.getViewportTopLeftX(), canvas.getViewportTopLeftY(), canvas.getViewportWidth(), canvas.getViewportHeight());
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            canvas.drawOnWorld(gc -> {
                for (Object2dFx object2d : this.objects) {
                    if (this.clipAtViewport && !object2d.intersectsWith(viewport, 5.0)) continue;
                    object2d.drawOnWorld(gc);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimePasses(double secondsElapsed) {
        this.updateObjects();
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            for (Object2dFx objet2d : this.objects) {
                objet2d.onTimePasses(secondsElapsed);
            }
        }
    }

    private void updateObjects() {
        this.removeObjectsImpl();
        this.addObjectsImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectsImpl() {
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            for (Object2dFx objectToAdd : this.objectsToAdd) {
                Integer index = this.objectIndex(objectToAdd);
                if (index != null) continue;
                this.objects.add(objectToAdd);
            }
        }
        this.objectsToAdd.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyDataFrom(World2dFx world2d) {
        this.updateObjects();
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            for (int i = 0; i < this.objects.size(); ++i) {
                world2d.copyDataTo(i, this.objects.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDataTo(int i, Object2dFx object2d) {
        this.updateObjects();
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            if (i < this.objects.size()) {
                object2d.copyDataFrom(this.objects.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchMouseEvent(World2dMouseEventFx world2dMouseEventFx) {
        this.updateObjects();
        double worldX = world2dMouseEventFx.worldX();
        double worldY = world2dMouseEventFx.worldY();
        boolean consumed = false;
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            for (Object2dFx object : this.objects) {
                if (!object.collidesWith(worldX - 5.0, worldY - 5.0, 10.0, 10.0)) continue;
                consumed = consumed || object.onMouseEvent(world2dMouseEventFx);
            }
        }
        if (!consumed) {
            this.onMouseEventNotConsumed(world2dMouseEventFx);
        }
    }

    public void removeObject(String objectId) {
        if (!this.idsOfObjectsToRemove.contains(objectId)) {
            this.idsOfObjectsToRemove.add(objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObjectsImpl() {
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            for (String idOfObjectToRemove : this.idsOfObjectsToRemove) {
                Integer indexOfObjectToRemove = this.objectIndexById(idOfObjectToRemove);
                if (indexOfObjectToRemove == null) continue;
                this.objects.remove(indexOfObjectToRemove);
            }
        }
        this.idsOfObjectsToRemove.clear();
    }

    public void removeObjectsWithIdIn(Set<String> idsOfObjectsToRemove) {
        for (String idOfObjectToRemove : idsOfObjectsToRemove) {
            if (this.idsOfObjectsToRemove.contains(idOfObjectToRemove)) continue;
            this.idsOfObjectsToRemove.add(idOfObjectToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjectsWithIdNotIn(Set<String> idsOfObjectToKeep) {
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            for (Object2dFx candidate : this.objects) {
                if (candidate == null || candidate.id() == null || idsOfObjectToKeep.contains(candidate.id()) || this.idsOfObjectsToRemove.contains(candidate.id())) continue;
                this.idsOfObjectsToRemove.add(candidate.id());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer objectIndex(Object2dFx object) {
        if (object == null) {
            return null;
        }
        Integer index = null;
        String id = object.id();
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            for (int i = 0; i < this.objects.size(); ++i) {
                Object2dFx candidate = this.objects.get(i);
                if (object == candidate) {
                    index = i;
                    break;
                }
                if (candidate == null || candidate.id() == null || !candidate.id().equals(id)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer objectIndexById(String id) {
        Integer index = null;
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            for (int i = 0; i < this.objects.size(); ++i) {
                Object2dFx candidate = this.objects.get(i);
                if (candidate == null || candidate.id() == null || !candidate.id().equals(id)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object2dFx objectById(String id) {
        this.updateObjects();
        Object2dFx result = null;
        List<Object2dFx> list = this.objects;
        synchronized (list) {
            Integer objectIndex = this.objectIndexById(id);
            if (objectIndex != null) {
                result = this.objects.get(objectIndex);
            }
        }
        return result;
    }
}

