/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.app.session;

import ca.ntro.app.Ntro;
import ca.ntro.app.messages.Message;
import ca.ntro.app.models.Model;
import ca.ntro.core.locale.Locale;
import ca.ntro.ntro_app_fx_abstr.models.ModelSelectionsWriter;
import ca.ntro.ntro_app_fx_abstr.session.SessionAbstr;
import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_app_fx_impl.models.SelectionsByModel;
import ca.ntro.ntro_app_fx_impl.modified.Observable;
import java.util.List;

public class Session<THIS extends Session<?>>
implements SessionAbstr<THIS>,
Observable {
    private String sessionId = Ntro.random().nextId(4);
    private SelectionsByModel modelSelections = new SelectionsByModel();
    private transient boolean isNamedSession = false;

    void registerSessionId(String sessionId) {
        this.sessionId = sessionId;
        this.isNamedSession = true;
    }

    boolean isNamedSession() {
        return this.isNamedSession;
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    public Locale locale() {
        return Ntro.currentLocale();
    }

    @Override
    public THIS setModelSelection(Class<? extends Model> modelClass, String modelId) {
        if (!this.modelSelections.isModelSelected(modelClass, modelId)) {
            this.modelSelections.setModelSelection((Class)modelClass, modelId);
            NtroImpl.messageService().observe(modelClass, modelId);
        }
        return (THIS)this;
    }

    @Override
    public THIS addModelSelection(Class<? extends Model> modelClass, String modelId) {
        if (!this.modelSelections.isModelSelected(modelClass, modelId)) {
            this.modelSelections.addModelSelection((Class)modelClass, modelId);
            NtroImpl.messageService().observe(modelClass, modelId);
        }
        return (THIS)this;
    }

    @Override
    public THIS clearModelSelections(Class<? extends Model> modelClass) {
        this.modelSelections.clearModelSelections((Class)modelClass);
        return (THIS)this;
    }

    public <MSG extends Message<?>> void copyModelSelectionsInto(ModelSelectionsWriter<?> otherSelections) {
        this.modelSelections.modelClasses().forEach(modelClass -> {
            otherSelections.clearModelSelections((Class<Model>)modelClass);
            this.modelSelections.selections((Class<? extends Model>)modelClass).forEach(modelId -> otherSelections.addModelSelection((Class<Model>)modelClass, (String)modelId));
        });
    }

    @Override
    public boolean isModelSelected(Class<? extends Model> modelClass, String modelId) {
        return this.modelSelections.isModelSelected(modelClass, modelId);
    }

    @Override
    public boolean hasModelSelections(Class<? extends Model> modelClass) {
        return this.modelSelections.hasModelSelections(modelClass);
    }

    @Override
    public String getModelSelection(Class<? extends Model> modelClass) {
        return this.modelSelections.getModelSelection(modelClass);
    }

    @Override
    public List<String> getModelSelections(Class<? extends Model> modelClass) {
        return this.getModelSelections(modelClass);
    }

    void reObserveModelSelections() {
        this.modelSelections.modelClasses().forEach(modelClass -> this.modelSelections.selections((Class<? extends Model>)modelClass).forEach(modelId -> NtroImpl.messageService().observe((Class<? extends Observable>)modelClass, (String)modelId)));
    }
}

