package depart.frontal.taches;

import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.vues.VueA;
import depart.frontal.vues.VueB;
import depart.frontal.vues.VueRacine;

import static ca.ntro.app.tasks.frontend.FrontendTasks.*;

public class TachesA {
	
	public static void creerTaches(FrontendTasks tasks) {
		
		tasks.taskGroup("TachesA")
		
		     .waitsFor(viewLoaders())
		
		     .contains(subTasks -> {
		    	 
				tacheA(subTasks);
				tacheB(subTasks);
				tacheC(subTasks);

		     });
	}

	private static void tacheB(FrontendTasks subTasks) {

		subTasks.task(create(VueRacine.class))

		     .waitsFor(viewLoader(VueRacine.class))

		     .executesAndReturnsValue(inputs -> {
		    	 
		    	 var objA = inputs.get(viewLoader(VueRacine.class));
		    	 var objB = objA.createView();

		    	 return objB;
		     });
	}

	private static void tacheA(FrontendTasks subTasks) {

		subTasks.task(create(VueA.class))

		     .waitsFor(viewLoader(VueA.class))

		     .executesAndReturnsValue(inputs -> {
		    	 
		    	 var objA = inputs.get(viewLoader(VueA.class));
		    	 var ojbB = objA.createView();

		    	 return ojbB;
		     });
	}

	private static void tacheC(FrontendTasks subTasks) {

		subTasks.task(create(VueB.class))

		     .waitsFor(viewLoader(VueB.class))

		     .executesAndReturnsValue(inputs -> {
		    	 
		    	 var objA = inputs.get(viewLoader(VueB.class));
		    	 var objB = objA.createView();

		    	 return objB;
		     });
	}


}
