package depart.frontal.taches;

import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.evenements.EvtA;
import depart.frontal.vues.VueA;
import depart.frontal.vues.VueRacine;

import static ca.ntro.app.tasks.frontend.FrontendTasks.*;

import ca.ntro.app.Ntro;

public class TachesB {
	
	public static void creerTaches(FrontendTasks tasks) {
		
		tasks.taskGroup("TachesB")
		
		     .waitsFor("TachesA")
		
		     .contains(subTasks -> {

				tacheB1(subTasks);

				tacheB2(subTasks);

				tacheB3(subTasks);

		     });
	}

	private static void tacheB1(FrontendTasks subTasks) {

		subTasks.task("tacheB1")
		
		      .waitsFor(window())
		      
		      .waitsFor(created(VueRacine.class))

		      .executes(inputs -> {
		    	  
		    	  var objA  = inputs.get(created(VueRacine.class));
		    	  var objB  = inputs.get(window());

		    	  objB.installRootView(objA);
		      });
	}

	private static void tacheB2(FrontendTasks tasks) {

		tasks.task("tacheB2")

		     .waitsFor(window())

		     .executes(inputs -> {

		    	 var objA = inputs.get(window());

		    	 objA.show();

		     });
	}

	private static void tacheB3(FrontendTasks tasks) {

		tasks.task("tacheB3")

		     .waitsFor(created(VueA.class))   // pour réagir modifs fichier vue_a.fxml

		     .executes(inputs -> {

		    	 Ntro.newEvent(EvtA.class).trigger();

		     });
	}

}
