package depart.frontal.taches;

import static ca.ntro.app.tasks.frontend.FrontendTasks.*;

import ca.ntro.app.Ntro;
import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.SessionDepart;
import depart.frontal.evenements.EvtA;
import depart.frontal.evenements.EvtB;
import depart.frontal.vues.VueA;
import depart.frontal.vues.VueB;
import depart.frontal.vues.VueRacine;

public class TachesC {
	
	public static void creerTaches(FrontendTasks tasks) {

		tasks.taskGroup("TachesC")
		
		     .waitsFor("TachesB")
		     
		     .contains(subTasks -> {

			     tacheC1(subTasks);

			     tacheC2(subTasks);

		     });
	}


	private static void tacheC2(FrontendTasks subTasks) {

		subTasks.task("tacheC2")
		
		     .waitsFor(event(EvtB.class))

		     .waitsFor(created(VueRacine.class))

		     .waitsFor(created(VueB.class))

		     .executes(inputs -> {

		    	 var objA = inputs.get(event(EvtB.class));
		    	 var objB = inputs.get(created(VueRacine.class));
		    	 var objC = inputs.get(created(VueB.class));
		    	 var objD = Ntro.session(SessionDepart.class);

		    	 objA.methodeA(objB, objC);

		    	 objD.methodeA(VueB.class);

		     });
		
	}

	private static void tacheC1(FrontendTasks tasks) {

		tasks.task("tacheC1")

		      .waitsFor(event(EvtA.class))

		      .waitsFor(created(VueRacine.class))

		      .waitsFor(created(VueA.class))

		      .executes(inputs -> {
		    	  
		    	  var objA = inputs.get(event(EvtA.class));
		    	  var objB = inputs.get(created(VueRacine.class));
		    	  var objC = inputs.get(created(VueA.class));
		    	  var objD = Ntro.session(SessionDepart.class);
		    	  
		    	  objA.methodeA(objB, objC);
		    	  
		    	  objD.methodeA(VueA.class);
		    	  
		      });
	}


}