package depart.frontal.taches;

import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.vues.VueA;
import depart.frontal.vues.VueB;
import depart.frontal.vues.VueRacine;

import static ca.ntro.app.tasks.frontend.FrontendTasks.*;

public class TachesA {
	
	public static void creerTaches(FrontendTasks tasks) {
		
		tasks.taskGroup("TachesA")
		
		     .waitsFor(viewLoaders())
		
		     .contains(subTasks -> {
		    	 
				tacheA1(subTasks);
				tacheA2(subTasks);
				tacheA3(subTasks);

		     });
	}

	private static void tacheA1(FrontendTasks subTasks) {

		subTasks.task(create(VueA.class))

		     .waitsFor(viewLoader(VueA.class))

		     .executesAndReturnsValue(inputs -> {
		    	 
		    	 var objA = inputs.get(viewLoader(VueA.class));
		    	 var objB = objA.createView();

		    	 return objB;
		     });
	}

	private static void tacheA2(FrontendTasks subTasks) {

		subTasks.task(create(VueRacine.class))

		     .waitsFor(viewLoader(VueRacine.class))

		     .executesAndReturnsValue(inputs -> {
		    	 
		    	 var objC = inputs.get(viewLoader(VueRacine.class));
		    	 var objD = objC.createView();

		    	 return objD;
		     });
	}

	private static void tacheA3(FrontendTasks subTasks) {

		subTasks.task(create(VueB.class))

		     .waitsFor(viewLoader(VueB.class))

		     .executesAndReturnsValue(inputs -> {
		    	 
		    	 var objE = inputs.get(viewLoader(VueB.class));
		    	 var objF = objE.createView();

		    	 return objF;
		     });
	}

}
