/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.world2d.region_tree;

import ca.ntro.core.stream.Stream;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.AnonymousRegion2d;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.Region2d;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.RegionTree2d;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.RegionTreeNode2dNtro;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RegionTree2dNtro<R extends Region2d>
implements RegionTree2d<R> {
    private Map<String, R> regionsById = new HashMap<String, R>();
    private RegionTreeNode2dNtro<R> rootNode;
    private double epsilon;

    public Map<String, R> getRegionsById() {
        return this.regionsById;
    }

    public void setRegionsById(Map<String, R> regionsById) {
        this.regionsById = regionsById;
    }

    public RegionTreeNode2dNtro<R> getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(RegionTreeNode2dNtro<R> rootNode) {
        this.rootNode = rootNode;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public RegionTree2dNtro(double topLeftX, double topLeftY, double width, double height, double epsilon) {
        this.rootNode = new RegionTreeNode2dNtro(topLeftX, topLeftY, width, height);
        this.setEpsilon(epsilon);
    }

    @Override
    public void add(R region) {
        this.regionsById.put(region.id(), region);
    }

    @Override
    public void remove(String id) {
        R region = this.get(id);
        if (region != null) {
            this.regionsById.remove(id);
            this.remove(region);
        }
    }

    @Override
    public void remove(R region) {
        HashSet toRemove = new HashSet();
    }

    @Override
    public void onRegionMoved(String id) {
        R region = this.get(id);
        if (region != null) {
            this.remove(id);
            this.add(region);
        }
    }

    @Override
    public R get(String id) {
        return (R)((Region2d)this.regionsById.get(id));
    }

    @Override
    public Stream<R> intersectWith(AnonymousRegion2d otherRegion) {
        return this.rootNode.intersectWith(otherRegion, this.epsilon);
    }

    @Override
    public Stream<R> intersectWith(double topLeftX, double topLeftY, double width, double height) {
        return this.rootNode.intersectWith(topLeftX, topLeftY, width, height, this.epsilon);
    }

    @Override
    public Stream<R> containedIn(AnonymousRegion2d otherRegion) {
        return this.rootNode.containedIn(otherRegion, this.epsilon);
    }

    @Override
    public Stream<R> containedIn(double topLeftX, double topLeftY, double width, double height) {
        return this.rootNode.containedIn(topLeftX, topLeftY, width, height, this.epsilon);
    }

    @Override
    public Stream<R> get(AnonymousRegion2d regionSpec) {
        return this.rootNode.get(regionSpec, this.epsilon);
    }

    @Override
    public Stream<R> get(double topLeftX, double topLeftY, double width, double height) {
        return this.rootNode.get(topLeftX, topLeftY, width, height, this.epsilon);
    }
}

