/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.tasks.backend;

import ca.ntro.app.messages.Message;
import ca.ntro.app.messages.MessageAccessor;
import ca.ntro.app.tasks.frontend.BlockingFrontendExecutor;
import ca.ntro.app.tasks.frontend.TypedBlockingFrontendExecutor;
import ca.ntro.core.NtroCore;
import ca.ntro.core.stream.Stream;
import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_app_fx_impl.models.SelectionsByModel;
import ca.ntro.ntro_app_fx_impl.structures.ClassIdMap;
import ca.ntro.ntro_app_fx_impl.tasks.SimpleTaskCreatorNtro;
import ca.ntro.ntro_app_fx_impl.tasks.TaskInputsNtro;
import ca.ntro.ntro_app_fx_impl.tasks.backend.BackendSimpleTaskCreator;
import ca.ntro.ntro_core_abstr.tasks.TaskAbstr;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.TaskContainer;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.TaskGraph;
import ca.ntro.ntro_core_impl.values.ObjectMap;
import ca.ntro.ntro_core_impl.values.ObjectMapNtro;
import java.util.List;
import java.util.Map;

public class BackendSimpleTaskCreatorNtro<O>
extends SimpleTaskCreatorNtro<O>
implements BackendSimpleTaskCreator<O> {
    public BackendSimpleTaskCreatorNtro(Map<String, TaskAbstr> orphanTasks, TaskGraph graph, TaskContainer parent, TaskAbstr task) {
        super(orphanTasks, graph, parent, task);
    }

    @Override
    protected void executeTask(BlockingFrontendExecutor executor, ObjectMap results) {
        this.createContextAndExecute(executor, results);
    }

    private synchronized void createContextAndExecute(BlockingFrontendExecutor executor, ObjectMap results) {
        ExecutionContext context = new ExecutionContext();
        context.aquireLock();
        context.loadModels(results);
        executor.execute(new TaskInputsNtro(this.getGraph(), (TaskAbstr)this.getTaskImpl(), context.newResults()));
        context.saveModels();
        context.releaseLock();
    }

    @Override
    protected Object executeTaskForValue(TypedBlockingFrontendExecutor<?> executor, ObjectMap results) {
        return this.createContextAndExecuteForValue(executor, results);
    }

    private synchronized Object createContextAndExecuteForValue(TypedBlockingFrontendExecutor<?> executor, ObjectMap results) {
        ExecutionContext context = new ExecutionContext();
        context.aquireLock();
        context.loadModels(results);
        Object result = executor.execute(new TaskInputsNtro(this.getGraph(), (TaskAbstr)this.getTaskImpl(), context.newResults()));
        context.saveModels();
        context.releaseLock();
        return result;
    }

    private class ExecutionContext {
        private ObjectMapNtro newResults = new ObjectMapNtro();
        private ClassIdMap<Object, Object> models = new ClassIdMap();
        private SelectionsByModel modelSelections = new SelectionsByModel();

        private ExecutionContext() {
        }

        ObjectMap newResults() {
            return this.newResults;
        }

        void aquireLock() {
        }

        void loadModels(ObjectMap results) {
            this.collectModelSelections(results);
            results.ids().forEach(id -> {
                if (id.startsWith("model[")) {
                    String classNameAndId = id.replace("model[", "");
                    classNameAndId = classNameAndId.replace("]", "");
                    String className = null;
                    String modelId = null;
                    String[] segments = classNameAndId.split("/");
                    if (segments.length == 1) {
                        className = segments[0];
                    } else if (segments.length == 2) {
                        className = segments[0];
                        modelId = segments[1];
                    } else {
                        NtroCoreImpl.logger().fatal("could not parse model task " + id);
                    }
                    Class modelClass = NtroCore.factory().namedClass(className);
                    if (modelId == null) {
                        modelId = (String)this.modelSelections.selections(modelClass).findFirst(x -> true);
                    }
                    Object model = NtroImpl.models().load(modelClass, modelId);
                    this.models.put(modelClass, modelId, model);
                    this.newResults.registerObject(id, model);
                } else {
                    this.newResults.registerObject(id, results.get(id));
                }
            });
        }

        private void collectModelSelections(ObjectMap results) {
            Stream messageIds = results.ids().findAll(id -> id.startsWith("message["));
            List messages = messageIds.map(messageId -> (Message)results.get(messageId)).collect();
            if (messages.size() > 0) {
                this.modelSelections = MessageAccessor.getModelSelections((Message)messages.get(0));
            }
            for (int i = 1; i < messages.size(); ++i) {
                MessageAccessor.mergeCompatibleModelSelectionsInto((Message)messages.get(i), this.modelSelections);
            }
        }

        void saveModels() {
            this.models.entries().forEach(entry -> NtroImpl.models().save(entry.entryClass(), entry.entryId(), entry.value()));
        }

        void releaseLock() {
        }
    }
}

