/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.services;

import ca.ntro.ntro_app_fx_impl.frontend.TickNtro;
import ca.ntro.ntro_app_fx_impl.services.TimeFx;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;

public class TimeFxJdkTimer
extends TimeFx {
    private Timer tickTimer = null;
    private AtomicBoolean fxReadyForNextTick = new AtomicBoolean(true);
    private long lastTick;

    @Override
    protected void startTickTimer() {
        this.stopTickTimer();
        this.tickTimer = new Timer();
        this.lastTick = this.nowNanoseconds();
        this.tickTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (TimeFxJdkTimer.this.fxReadyForNextTick.get()) {
                    TimeFxJdkTimer.this.fxReadyForNextTick.set(false);
                    Platform.runLater(() -> {
                        long tick = TimeFxJdkTimer.this.nowNanoseconds();
                        double elapsed = (double)(tick - TimeFxJdkTimer.this.lastTick) / 1.0E9;
                        TimeFxJdkTimer.this.lastTick = tick;
                        if (TimeFxJdkTimer.this.getTickHandler() != null) {
                            TimeFxJdkTimer.this.getTickHandler().addResult((Object)new TickNtro(elapsed));
                        }
                        TimeFxJdkTimer.this.fxReadyForNextTick.set(true);
                    });
                }
            }
        }, 0L, 2L);
    }

    @Override
    protected void stopTickTimer() {
        if (this.tickTimer != null) {
            this.tickTimer.cancel();
        }
    }
}

