/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.frontend.window;

import ca.ntro.core.NtroCore;
import ca.ntro.ntro_app_fx_impl.frontend.window.FatalErrorCanvas;
import ca.ntro.ntro_app_fx_impl.frontend.window.FatalErrorWorld2d;
import ca.ntro.ntro_app_fx_impl.frontend.window.SpaceHorizontal;
import ca.ntro.ntro_app_fx_impl.frontend.window.SpaceVertical;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class FatalErrorView
extends StackPane {
    private VBox mainVBox = new VBox();
    private HBox animationHBox = new HBox();
    private VBox animationVBox = new VBox();
    private Label fpsLabel = new Label();
    private FatalErrorCanvas canvas = new FatalErrorCanvas();
    private FatalErrorWorld2d world2d = new FatalErrorWorld2d();
    private HBox messageHBox = new HBox();
    private VBox messageTextFlowVBox = new VBox();
    private HBox messageTextFlowHBox = new HBox();
    private TextFlow messageTextFlow = new TextFlow();
    private long previousNanotime = System.nanoTime();
    private long imagesDrawnSinceLastFpsMeasure = 0L;
    private double elapsedTimeSinceLastFpsMeasure = 0.0;
    private double secondsBetweenFpsMeasures = 0.2;

    public FatalErrorView() {
        this.setStyle("-fx-background-color:#be133f;");
        this.getChildren().add((Object)this.mainVBox);
        this.canvas.initialize();
        this.world2d.initialize();
        this.canvas.setMinWidth(100.0);
        this.canvas.setMinHeight(50.0);
        this.canvas.setMaxWidth(800.0);
        this.canvas.setMaxHeight(400.0);
        this.mainVBox.getChildren().add((Object)this.animationHBox);
        this.animationHBox.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this.animationHBox, (Priority)Priority.ALWAYS);
        this.animationHBox.getChildren().add((Object)new SpaceHorizontal(20.0, 100.0));
        this.animationHBox.getChildren().add((Object)this.animationVBox);
        HBox.setHgrow((Node)this.animationVBox, (Priority)Priority.ALWAYS);
        this.animationVBox.setAlignment(Pos.CENTER);
        this.animationHBox.getChildren().add((Object)new SpaceHorizontal(20.0, 100.0));
        this.animationVBox.getChildren().add((Object)new SpaceVertical(10.0, 20.0));
        this.animationVBox.getChildren().add((Object)this.fpsLabel);
        this.animationVBox.getChildren().add((Object)this.canvas);
        VBox.setVgrow((Node)this.canvas, (Priority)Priority.ALWAYS);
        this.animationVBox.getChildren().add((Object)new SpaceVertical(10.0, 20.0));
        this.fpsLabel.setStyle("-fx-text-fill:#2b2828;");
        this.mainVBox.getChildren().add((Object)new SpaceVertical(20.0, 40.0));
        this.mainVBox.getChildren().add((Object)this.messageHBox);
        VBox.setVgrow((Node)this.messageHBox, (Priority)Priority.ALWAYS);
        this.mainVBox.getChildren().add((Object)new SpaceVertical(20.0, 40.0));
        this.messageHBox.setAlignment(Pos.TOP_CENTER);
        this.messageHBox.getChildren().add((Object)new SpaceHorizontal(20.0, 40.0));
        this.messageHBox.getChildren().add((Object)this.messageTextFlowHBox);
        this.messageHBox.getChildren().add((Object)new SpaceHorizontal(20.0, 40.0));
        HBox.setHgrow((Node)this.messageTextFlowHBox, (Priority)Priority.ALWAYS);
        this.messageTextFlowHBox.setStyle("-fx-background-color:#f61f56;-fx-background-radius:12;");
        this.messageTextFlowHBox.getChildren().add((Object)new SpaceHorizontal());
        this.messageTextFlowHBox.getChildren().add((Object)this.messageTextFlowVBox);
        this.messageTextFlowHBox.getChildren().add((Object)new SpaceHorizontal());
        HBox.setHgrow((Node)this.messageTextFlowVBox, (Priority)Priority.ALWAYS);
        this.messageTextFlowVBox.getChildren().add((Object)new SpaceVertical());
        this.messageTextFlowVBox.getChildren().add((Object)this.messageTextFlow);
        this.messageTextFlowVBox.getChildren().add((Object)new SpaceVertical());
        this.messageTextFlowVBox.setAlignment(Pos.CENTER);
        this.messageTextFlowVBox.setMinHeight(200.0);
        this.messageTextFlow.setStyle("-fx-font-size:2em;-fx-text-fill:#2b2828;-fx-font-family:" + FatalErrorWorld2d.FONT_SANS + ";");
    }

    public void displayMessage(String message) {
        Text messageText = new Text(message);
        messageText.setFill((Paint)Color.web((String)"#2b2828"));
        this.messageTextFlow.getChildren().add((Object)messageText);
        this.world2d.drawOn(this.canvas);
        this.previousNanotime = System.nanoTime();
        NtroCore.time().runRepeatedly(1L, () -> {
            this.canvas.clearCanvas();
            long currentNanotime = System.nanoTime();
            double elapsedSeconds = (double)(currentNanotime - this.previousNanotime) / 1.0E9;
            this.world2d.onTimePasses(elapsedSeconds);
            this.previousNanotime = currentNanotime;
            this.world2d.drawOn(this.canvas);
            ++this.imagesDrawnSinceLastFpsMeasure;
            this.elapsedTimeSinceLastFpsMeasure += elapsedSeconds;
            if (this.elapsedTimeSinceLastFpsMeasure >= this.secondsBetweenFpsMeasures) {
                this.fpsLabel.setText("FPS " + Math.round((double)this.imagesDrawnSinceLastFpsMeasure / this.secondsBetweenFpsMeasures));
                this.elapsedTimeSinceLastFpsMeasure = 0.0;
                this.imagesDrawnSinceLastFpsMeasure = 0L;
            }
        });
    }
}

