/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.executable_spec;

import ca.ntro.app.tasks.SimpleTaskCreator;
import ca.ntro.app.tasks.frontend.BlockingFrontendExecutor;
import ca.ntro.app.tasks.frontend.TypedBlockingFrontendExecutor;
import ca.ntro.core.NtroCore;
import ca.ntro.core.tasks.Task;
import ca.ntro.ntro_app_fx_impl.tasks.TaskCreator;
import ca.ntro.ntro_app_fx_impl.tasks.TaskDescriptor;
import ca.ntro.ntro_app_fx_impl.tasks.WaitsFor;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.values.CodeLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskSpec
implements SimpleTaskCreator,
TaskCreator,
Task {
    private List<String> waitsFors = new ArrayList<String>();
    private boolean returnsResult = false;
    private transient Object executor = null;
    private transient Map<String, TaskDescriptor> waitsForDescriptors = new HashMap<String, TaskDescriptor>();
    private transient Map<String, Throwable> deferredExceptions = new HashMap<String, Throwable>();
    private transient Map<String, CodeLocation> waitsForLocations = new HashMap<String, CodeLocation>();

    @Override
    public Task getTask() {
        return this;
    }

    @Override
    public TaskCreator waitsFor(String taskId) {
        CodeLocation waitsForLocation = NtroCoreImpl.stackAnalyzer().callingLocationOf(new Throwable());
        this.waitsFors.add(taskId);
        this.waitsForLocations.put(taskId, waitsForLocation);
        this.deferredExceptions.put(taskId, new Throwable(""));
        return this;
    }

    @Override
    public TaskCreator waitsFor(TaskDescriptor descriptor) {
        CodeLocation waitsForLocation = NtroCoreImpl.stackAnalyzer().callingLocationOf(new Throwable());
        String taskId = descriptor.id();
        this.waitsFors.add(taskId);
        this.waitsForDescriptors.put(taskId, descriptor);
        this.waitsForLocations.put(taskId, waitsForLocation);
        this.deferredExceptions.put(taskId, new Throwable(""));
        return this;
    }

    public SimpleTaskCreator executes(BlockingFrontendExecutor executor) {
        this.returnsResult = false;
        this.executor = executor;
        return this;
    }

    public SimpleTaskCreator executesAndReturnsValue(TypedBlockingFrontendExecutor executor) {
        this.returnsResult = true;
        this.executor = executor;
        return this;
    }

    public void cancel() {
    }

    public void addWaitsFors(WaitsFor taskCreator) {
        for (String waitsForId : this.waitsFors) {
            TaskDescriptor descriptor = this.waitsForDescriptors.get(waitsForId);
            if (descriptor != null) {
                try {
                    taskCreator.waitsFor(descriptor);
                }
                catch (RuntimeException e) {
                    this.fatal(waitsForId, e.getMessage());
                }
                continue;
            }
            try {
                taskCreator.waitsFor(waitsForId);
            }
            catch (RuntimeException e) {
                this.fatal(waitsForId, e.getMessage());
            }
        }
    }

    private void fatal(String waitsForId, String msg) {
        CodeLocation codeLocation = this.waitsForLocations.get(waitsForId);
        Throwable deferredException = this.deferredExceptions.get(waitsForId);
        if (deferredException != null) {
            NtroCore.logger().fatal(msg, deferredException);
        } else {
            NtroCore.logger().fatal(msg);
        }
    }

    public void addExecutor(SimpleTaskCreator taskCreator) {
        if (this.returnsResult && this.executor != null) {
            taskCreator.executesAndReturnsValue((TypedBlockingFrontendExecutor)this.executor);
        } else if (!this.returnsResult && this.executor != null) {
            taskCreator.executes((BlockingFrontendExecutor)this.executor);
        }
    }
}

